test_that("object classes and types", 
  {
    map = map_leaflet_multilayer(
      base_layer = list(
          perimeter = so.ii::so_ii_limit
      ),
      base_color = list(
          perimeter = data.frame(
              id = "perimeter",
              label = "perimeter",
              color = "white",
              fill = "transparent",
              opacity = 1
          )
      ),
      overlay_layer = list(
          hydro = so.ii::so_ii_hydro["type"]
      ),
      overlay_color = list(
          hydro = data.frame(
              id = unique(so.ii::so_ii_hydro[["type"]]),
              label = unique(so.ii::so_ii_hydro[["type"]]),
              color = scales::alpha(c("blue", "red", "dodgerblue"), 0.5), 
              fill = scales::alpha(c("blue", "red", "dodgerblue"), 0.5),
              opacity = 0.5
          )
      ),
      overlay_junction = list(
          hydro = c("type", "id")
      ),
      map_bg = so.ii::set_provider("ign_ortho"),
      bg_opacity = 0.6
    )

    enhanced_sf = add_visual_param(
      layer = so_ii_hydro,
      visual_param = data.frame(
        id = unique(so_ii_hydro[["type"]]),
        color = c("blue", "red", "dodgerblue"), 
        fill = c("blue", "red", "dodgerblue"),
        opacity = 0.5
      ),
      junction = c("type", "id")
    )

    enhanced_sfc = add_visual_param(
      layer = so_ii_limit,
      visual_param = data.frame(
        id = "perimeter",
        label = "perimeter",
        color = "white",
        fill = "transparent",
        opacity = 1
      ),
      junction = c("type", "id")
    )

    expect_type(map, "list")
    expect_s3_class(map, "leaflet", exact = FALSE)
    expect_type(enhanced_sf, "list")
    expect_s3_class(enhanced_sf, "sf", exact = FALSE)
    expect_type(enhanced_sfc, "list")
    expect_s3_class(enhanced_sfc, "sf", exact = FALSE)
  }
)
