test_that("add_visual_param() function works", 
  {
    visual_param = data.frame(
      id = unique(so_ii_hydro[["type"]]),
      color = c("blue", "red", "dodgerblue"), 
      fill = c("blue", "red", "dodgerblue"),
      opacity = 0.5
    )

    expect_error(
      add_visual_param(
        layer = so_ii_hydro,
        visual_param = visual_param
      )
    )

    expect_error(
      add_visual_param(
        layer = so_ii_hydro,
        visual_param = visual_param,
        junction = c("type")
      )
    )

    expect_error(
      add_visual_param(
        layer = so_ii_hydro,
        visual_param = visual_param,
        junction = c("type", "id", "toto")
      )
    )

    expect_no_error(
      add_visual_param(
        layer = so_ii_hydro,
        visual_param = visual_param,
        junction = c("type", "id")
      )
    )

    expect_warning(
      add_visual_param(
        layer = so_ii_limit,
        visual_param = visual_param
      )
    )

    expect_warning(
      add_visual_param(
        layer = so_ii_limit,
        visual_param = visual_param,
        junction = c("type", "id", "toto")
      )
    )

    visual_param = data.frame(
        id = "perimeter",
        label = "perimeter",
        color = "white",
        fill = "transparent",
        opacity = 1
    )    

    expect_no_warning(
      add_visual_param(
        layer = so_ii_limit,
        visual_param = visual_param
      )
    )

  }
)
