% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{so_ii_collectivity}
\alias{so_ii_collectivity}
\title{Spatial definition of collectivities included in so-ii}
\format{
sf data.frame 78 rows, 11 variables
\describe{
\item{commune_name}{character, INSEE code of the collectivity}
\item{syble}{logical, membership in SYBLE}
\item{symbo}{logical, membership in SYMBO}
\item{commune_name}{character, official name of the collectivity}
\item{commune_name_cap}{character, official capitalized name of the
collectivity}
\item{departement}{character, INSEE code of the departement of the
collectivity}
\item{region}{character, INSEE code of the region of the
collectivity}
\item{epci}{character, INSEE code of the EPCI of the collectivity}
\item{epci_name}{character, Name of the EPCI of the collectivity}
\item{epci_nature}{character, Nature of the EPCI of the collectivity}
}
}
\source{
\url{https://www.data.gouv.fr/fr/datasets/admin-express/}
}
\usage{
so_ii_collectivity
}
\description{
A dataset containing the spatial definition of all collectivities
included in so-ii and some administrative informations.
}
\details{
Basically this dataset is obtained as a selection from the layer
COMMUNE in ADMIN EXPRESS, more a renaming of variables. It is then added
information from EPCI in ADMIN EXPRESS and the membership to SYBLE and
SYMBO.
}
\keyword{datasets}
