% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_provider.R
\name{set_provider}
\alias{set_provider}
\title{Set a background map provider}
\usage{
set_provider(alias, attribution = TRUE)
}
\arguments{
\item{alias}{character specifying the alias of the map provider to use.
Admissible values are "ign_ortho" and "ign_plan". See details}

\item{attribution}{logical. Should the attribution information also be
provided? defaults to TRUE.}
}
\value{
A list or character vector:
\itemize{
\item If \code{attribution} is TRUE, returns a list containing the provider and
attribution
\item If \code{attribution} is FALSE, returns a character vector containing the
provider.
}
}
\description{
This function sets the map provider based on the specified provider alias. It
retrieves the corresponding provider and attribution information from an
internal database of available background map providers.
}
\details{
If no provider is specified, the function issues a warning and sets
provider = "ign_ortho" by default. Available aliases are:
\itemize{
\item "ign_ortho": Orthophotos from IGN (Institut national de l'information
géographique et forestière)
\item "ign_plan": Plan IGN v2 (Cartographie multi-échelles sur le territoire
national français de l'Institut national de l'information géographique et
forestière)
\item "ign_parcellaire": cadastral plots from IGN (Cartographie parcellaire
cadastral multi-échelles sur le territoire national français de l'Institut
national de l'information géographique et forestière)
\item "ign_3d": IGN's 3D representation using shading derived from MNH LiDAR HD (
estompage issu du MNH LiDAR HD de l'Institut national de l'information
géographique et forestière)
\item "ign_building": BD TOPO® V3 - Buildings layer (BD TOPO® V3 - Bâtiments de
l'Institut national de l'information géographique et forestière)
\item "ign_rpg": French land parcel identification system (RPG Dernière édition
de l'Institut national de l'information géographique et forestière)
\item "ign_aoc_viti": IGN's AOC wine region boundaries (délimitations
parcellaires AOC viticoles (INAO) de l'Institut national de l'information
géographique et forestière)
}
}
\examples{

# issues warning and returns provider "ign_ortho" and attribution information
set_provider() 

# returns provider "ign_ortho" and attribution information without warning
set_provider("ign_ortho")

# Sets the provider to "ign_plan" and returns only the provider
set_provider("ign_plan", attribution = FALSE)  

}
\seealso{
Other interactive mapping: 
\code{\link{add_leaflet_layer}()},
\code{\link{add_visual_param}()},
\code{\link{map_leaflet_commune}()},
\code{\link{map_leaflet_multilayer}()}
}
\concept{interactive mapping}
