% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_legend.R
\encoding{UTF-8}
\name{plot_legend}
\alias{plot_legend}
\title{Plot a legend independently of a map}
\usage{
plot_legend(dataset_legend, path = NULL, horiz = TRUE, add = FALSE)
}
\arguments{
\item{dataset_legend}{list of parameters to be passed to legend}

\item{path}{character, the name of the file to save the plot. Graphical
device is chosen depending on extension. See details.}

\item{horiz}{logical, should the legend be horizontal}

\item{add}{logical, should the legend be added to the current plot}
}
\value{
Nothing useful.
}
\description{
Plot a legend independently of a map
}
\details{
\subsection{path specification}{
Depending on the extension a device is chosen.
\itemize{
\item{\strong{pdf}: grDevices::cairo_pdf}
\item{\strong{png}: grDevices::png}
\item{\strong{svg}: grDevices::svg}
}
If path is NULL, standard plotting is used. If an extension is not managed,
an error is raised.
}
}
\examples{

dataset_legend = list(
 title = "Beatutiful legend",
 legend = c("red circle", "black square", "blue diamond"),
 pch = 21:23,
 pt.bg = c("red", "black", "blue")
)
plot_legend(dataset_legend)
plot_legend(dataset_legend, horiz = FALSE)
}
