% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_leaflet_multilayer.R
\name{map_leaflet_multilayer}
\alias{map_leaflet_multilayer}
\title{Create a leaflet map of the so-ii territory with several layers}
\usage{
map_leaflet_multilayer(
  base_layer,
  base_color,
  base_junction = NULL,
  overlay_layer,
  overlay_color,
  overlay_junction = NULL,
  map_bg = set_provider("ign_ortho"),
  bg_opacity = 0.2,
  point_marker = "marker",
  show_popup = TRUE
)
}
\arguments{
\item{base_layer}{list of named sf objects, where the sf objects are the
base layers to add to the map and the names the labels of the layers}

\item{base_color}{list of named data.frames, where the color vectors
contain all colors for all of the geometries of the corresponding sf object
in the \code{base_layer} parameter. Names should be the same as in \code{base_layer}}

\item{base_junction}{list of vectors containing the column names with which
each object in \code{base_layer} can be joined to the corresponding object in
\code{base_color} in a merge operation. It must be the same length as
\code{base_layer}. Names should be the same as in \code{overlay_layer}. If the layer
class is "sfc", the junction can be omitted. Defaults to \code{NULL}.}

\item{overlay_layer}{list of named sf objects, where the sf objects are the
overlay layers to add to the map and the names the labels of the layers}

\item{overlay_color}{list of named color vectors, where the color
vectors contain all colors for all of the geometries of the corresponding sf
object in the \code{overlay_layer} parameter. Names should be the same as in
\code{overlay_layer}}

\item{overlay_junction}{list of vectors containing the column names with
which each object in \code{overlay_layer} can be joined to the corresponding
object in \code{overlay_color} in a merge operation. It must be the same length
as \code{overlay_layer}. Names should be the same as in \code{overlay_layer}. If the
layer class is "sfc", the junction can be omitted. Defaults to \code{NULL}.}

\item{map_bg}{named list, containing the background map provider URL and the
attribution text, as issued from the function \code{set_provider()}}

\item{bg_opacity}{numeric, background map opacity; values should be between 0
and 1. Defaults to 0.2}

\item{point_marker}{character string specifying the type of marker to use for
point geometries. Valid options are "marker", "circle", and "popup".
Defaults to "marker".}

\item{show_popup}{Logical. It indicates whether to display popups for
features in the layer. Defaults to \code{TRUE}.}
}
\value{
A Leaflet map object (invisibly). The map is displayed in the viewer
or within an R Markdown or quarto document.
}
\description{
This function generates an interactive Leaflet map displaying multiple
layers.It uses spatial data from \code{sf} objects of type polygon, multipolygon,
linestring and multilinestring. The function adds a base map layer using
tile provider and then overlays the layers.
}
\details{
The function internally calls the function \code{add_leaflet_layer()}, enabling it
to differentiate between polygon, polyline, and point geometries within the
\code{layer} object. The layer's legend is also added to the map, displaying the
unique fill colors and corresponding labels from the layer's attributes (only
for non-point geometries).

The \code{layer} (sf object) provided to this function is expected to include the
following attributes in its associated \code{data.frame}:
\itemize{
\item color: A character or numeric vector specifying the color of the feature
(used for polygons and polylines).
\item opacity: A numeric value between 0 and 1 indicating the opacity of the
feature (used for polygons and polylines).
\item fill: A character or numeric vector specifying the fill color of the
feature (used for polygons).
\item label: A character vector providing a label or description for each feature
This label is used as the legend label for polygon and line geometries.
\item popup: If show_popup = TRUE, a character vector containing HTML-formatted
text
}
}
\examples{

\dontrun{
# Example 1
map_leaflet_multilayer(
    base_layer = list(
        perimeter = so.ii::so_ii_limit
    ),
    base_color = list(
        perimeter = data.frame(
            id = "perimeter",
            label = "so-ii perimeter",
            popup = "so-ii",
            color = "white",
            fill = "transparent",
            opacity = 1
        )
    ),
    overlay_layer = list(
        clc = so.ii::so_ii_clc["color"]
    ),
    overlay_color = list(
        clc = data.frame(
            id = so.ii::clc_color[["color"]],
            label = so.ii::clc_color[["label_fr"]],
            popup = so.ii::clc_color[["label_fr"]],
            color = so.ii::clc_color[["color"]], 
            fill = so.ii::clc_color[["color"]],
            opacity = 1
        )
    ),
    overlay_junction = list(
        clc = c("color", "id")
    ),
    map_bg = so.ii::set_provider("ign_3d"),
    bg_opacity = 0.6
)

# Example 2
map_leaflet_multilayer(
    base_layer = list(
        perimeter = so.ii::so_ii_limit
    ),
    base_color = list(
        perimeter = data.frame(
            id = "perimeter",
            label = "so-ii perimeter",
            popup = "so-ii",
            color = "white",
            fill = "transparent",
            opacity = 1
        )
    ),
    overlay_layer = list(
        clc = so.ii::so_ii_clc["color"],
        hydro = so.ii::so_ii_hydro["type"]
    ),
    overlay_color = list(
        clc = data.frame(
            id = so.ii::clc_color[["color"]],
            label = so.ii::clc_color[["label_fr"]],
            popup = so.ii::clc_color[["label_fr"]],
            color = so.ii::clc_color[["color"]], 
            fill = so.ii::clc_color[["color"]],
            opacity = 1
        ),
        hydro = data.frame(
            id = unique(so.ii::so_ii_hydro[["type"]]),
            label = unique(so.ii::so_ii_hydro[["type"]]),
            popup = unique(so.ii::so_ii_hydro[["type"]]),
            color = scales::alpha(c("blue", "red", "dodgerblue"), 0.5), 
            fill = scales::alpha(c("blue", "red", "dodgerblue"), 0.5),
            opacity = 0.5
        )
    ),
    overlay_junction = list(
        clc = c("color", "id"),
        hydro = c("type", "id")
    ),
    map_bg = so.ii::set_provider("ign_3d"),
    bg_opacity = 0.6,
    show_popup = FALSE
)

# Example3
library(sf)
random_points = data.frame(
    label = c("point1", "point2", "point3"),
    long = c(3.821011, 3.870760, 3.896732),
    lat = c(43.55250, 43.65147, 43.61877)
)

random_points = sf::st_as_sf(
    x = random_points,
    coords = c("long","lat"),
    crs = sf::st_crs(so_ii_hydro)
)
map_leaflet_multilayer(
    base_layer = list(
        perimeter = so.ii::so_ii_limit
    ),
    base_color = list(
        perimeter = data.frame(
            id = "perimeter",
            label = "perimeter",
            color = "white",
            fill = "transparent",
            opacity = 1
        )
    ),
    overlay_layer = list(
        hydro = so.ii::so_ii_hydro,
        random_points = random_points
    ),
    overlay_color = list(
        hydro = data.frame(
            id = unique(so.ii::so_ii_hydro[["type"]]),
            label = unique(so.ii::so_ii_hydro[["type"]]),
            color = scales::alpha(c("blue", "red", "dodgerblue"), 0.5), 
            fill = scales::alpha(c("blue", "red", "dodgerblue"), 0.5),
            opacity = 0.5
        ),
        random_points = data.frame(
            id = unique(random_points[["label"]]),
            label = unique(random_points[["label"]]),
            color = NA, 
            fill = NA,
            opacity = 0.5,
            popup = sprintf("this is random \%s", random_points[["label"]])
        )
    ),
    overlay_junction = list(
        hydro = c("type", "id"),
        random_points = "label"
    ),
    map_bg = so.ii::set_provider("ign_ortho"),
    bg_opacity = 0.6
)
}
}
\seealso{
Other interactive mapping: 
\code{\link{add_leaflet_layer}()},
\code{\link{add_visual_param}()},
\code{\link{map_leaflet_commune}()},
\code{\link{set_provider}()}
}
\concept{interactive mapping}
