% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_leaflet_commune.R
\name{map_leaflet_commune}
\alias{map_leaflet_commune}
\title{Create a leaflet map with popup information at commune level}
\usage{
map_leaflet_commune(
  dataset = so.ii::so_ii_collectivity,
  map_bg = set_provider("ign_ortho")
)
}
\arguments{
\item{dataset}{sf object, data to be plotted.
Default to \code{so_ii_collectivity}. See details}

\item{map_bg}{named list, containing the background map provider URL and the
attribution text, as issued from the function \code{set_provider()}}
}
\value{
A Leaflet map object (invisibly). The map is displayed in the viewer
or within an R Markdown or quarto document.
}
\description{
This function generates an interactive Leaflet map displaying commune-level
data, with customizable styling and popups. It uses spatial data from an \code{sf}
object to render polygons representing communes on the map.

The function adds a base map layer using the provided \code{map_bg} information
and then overlays polygons representing the communes.  Communes are styled
with a light fill color and a transparent background. When a commune is
clicked, its corresponding \code{popup} content is displayed. A background polygon
representing the overall limit is also added for context.
}
\details{
\code{dataset} should contain valid html content in \code{popup} variable added to the
tributary table of the sf object. If this column does not exist, the
function issues a warning and generate and empty \code{popup} column
}
\examples{

\dontrun{
# example 1
dataset = so.ii::so_ii_collectivity
dataset[["popup"]] = paste(
 dataset[["commune_name"]],
 sprintf("(\%s hab)", formatC(so_ii_population[,"2019"], big.mark = " ", format = "d"))
)
map_leaflet_commune(dataset)

# example 2:  issues warning and creates empty popup
map_leaflet_commune()
}
}
\seealso{
Other interactive mapping: 
\code{\link{add_leaflet_layer}()},
\code{\link{add_visual_param}()},
\code{\link{map_leaflet_multilayer}()},
\code{\link{set_provider}()}
}
\concept{interactive mapping}
