% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linesep.R
\encoding{UTF-8}
\name{linesep}
\alias{linesep}
\title{Create a linesep for kable}
\usage{
linesep(x, n)
}
\arguments{
\item{x}{vector, either numerical or logical, position for separation}

\item{n}{integer, length of result}
}
\value{
A character vector of linesep to be used un kable.
}
\description{
Create a linesep for kable
}
\examples{

temp = iris[sample(seq_len(nrow(iris)), 10),]
kable(temp, linesep = linesep(diff(as.integer(temp[["Species"]])) != 0))
kable(temp, linesep = linesep(temp[["Species"]][-1] != temp[["Species"]][-nrow(temp)]))

temp = temp[order(temp[["Species"]]), ]
kable(temp, linesep = linesep(cumsum(table(temp[["Species"]]))))
}
\author{
This is an adaptation of the function inset of the terra package.
}
