% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_db_typology.R
\encoding{UTF-8}
\name{generate_db_typology}
\alias{generate_db_typology}
\title{Generate data from BD-Topo-dwelling for the so-ii communes}
\usage{
generate_db_typology(dataset, vintage, path, retrieve = FALSE)
}
\arguments{
\item{dataset}{data from BD-Topo-dwelling. See details.}

\item{vintage}{edition (as date) of the BD-Topo® used in \code{dataset}.}

\item{path}{character, the name of the file to save the plot. Graphical
device is chosen depending on extension.}

\item{retrieve}{logical, should the result be returned?. default to FALSE}
}
\value{
subject to the value of parameter \code{retrieve}:
\itemize{
\item FALSE (default): the function does not return an object. It stores the
database (csv.gz file) and the metadata (yml file) in path.
\item TRUE: the function returns a list with two slots, one for the data (as
data.frame) and one for the metadata (as character). It also stores the
database (csv.gz file) and the metadata (yml file) in path.
}
}
\description{
The function extracts the data from the the BD-Topo-dwelling
created by the R library \href{https://floodam.org/floodam.data/}{floodam.data}
for the so-ii communes. Then it summarizes the data and creates the database
that serves as input for the analysis \href{https://so-ii.org/analyse/analyse/logement-bd-topo-so-ii.html}{"Typologie des bâtiments résidentiels sur le territoire so-ii"}
available in the \href{https://so-ii.org}{so-ii website}
}
\details{
A workflow integrating libraries \href{https://floodam.org/floodam.data/}{floodam.data}
and \href{https://floodam.org/so.ii/}{so-ii} is proposed in the
\href{https://so-ii.org/methode/tutoriel/donnees_bd_topo_so-ii.html}{so-ii website}
We strongly recomend to visit the web page and follow the steps described
there.
}
\examples{

\dontrun{
# To be added (soon)
}
}
