% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alert_mattermost.R
\encoding{UTF-8}
\name{alert_mattermost}
\alias{alert_mattermost}
\title{Send a message to a mattermost server}
\usage{
alert_mattermost(
  msg,
  server,
  hook,
  user = "nono",
  channel = NULL,
  alert = TRUE
)
}
\arguments{
\item{msg}{character, the message to be sent. Each element is a considered as
a line.}

\item{server}{character, the address of the mattermost server.}

\item{hook}{character, the ID of the webhook defined in the mattermost
server.}

\item{user}{character, the name of the user.}

\item{channel}{character, the ID of the channel. Default to NULL, in that
case, the default channel defined at mattermost server level fot the webhook
will be used.}

\item{alert}{logical, should the alert be send to the mattermost server.}
}
\value{
If alert is FALSE, the command generated to send the message.
}
\description{
Send a message to a mattermost server
}
\examples{

\dontrun{
msg = "Ceci est un test !"
hook = "nf71q9d5u7dwxmpygz75gpqyqr"
server = "https://mattermost.g-eau.fr"
alert_mattermost(msg, server, hook)
}
}
