% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate_wide.R
\encoding{UTF-8}
\name{aggregate_wide}
\alias{aggregate_wide}
\title{A wrapper to aggregate that gives a wide view of results}
\usage{
aggregate_wide(x, what, fun = sum)
}
\arguments{
\item{x}{data.frame}

\item{what}{vector of length}

\item{fun}{function}
}
\value{
A matrix of result
}
\description{
A wrapper to aggregate that gives a wide view of results
}
\examples{
x = data.frame(
    gender = sample(c("H", "F"), 20, replace = TRUE),
    region = sample(c("east", "west", "south", "north"), 20, replace = TRUE),
    wealth = round(runif(20) * 10000),
    size = round(runif(20) * 50 + 150)
)
aggregate_wide(x)
aggregate_wide(x, c("region", "gender", "wealth"))
aggregate_wide(x, c("region", "gender", "size"))
aggregate_wide(x, c("region", "gender", "wealth"), mean)
}
