% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_leaflet_multilayer.R
\name{add_visual_param}
\alias{add_visual_param}
\title{Add Visual Parameters to a Spatial Layer}
\usage{
add_visual_param(layer, visual_param, junction = NULL)
}
\arguments{
\item{layer}{spatial object, either an \code{sf} object or an \code{sfc} object. This
is the layer to which visual parameters will be added.}

\item{visual_param}{\code{data.frame} containing the visual parameters to add.
This should have a common identifier with the \code{layer}object for merging.}

\item{junction}{character vector specifying the column name(s) to use for
merging the \code{layer} and \code{visual_param} objects. For \code{sf} objects, this
defines the join key. If missing for \code{sf} objects, an error is thrown.}
}
\value{
spatial object (\code{sf}) with the visual parameters added as
new attributes.
}
\description{
This function enhances a spatial layer (either \code{sf} or \code{sfc} object) with
visual parameters, typically colors or other attributes, using a merge
operation (\code{sf}) or direct attribute addition (\code{sfc}).
}
\details{
For \code{sf} objects, the function merges the \code{layer} and \code{visual_param}
data frames based on the specified \code{junction} column.  If a single \code{junction}
is provided, a standard merge is performed. If two \code{junction} values are
provided, the merge is done using \code{by.x} and \code{by.y}.  If more than two
junction values are provided, the function stops with an error.
For \code{sfc} objects, the visual parameters are directly added as new attributes
to the \code{sfc} object.
}
\examples{

enhanced_sf = add_visual_param(
  layer = so_ii_hydro,
  visual_param = data.frame(
     id = unique(so.ii::so_ii_hydro[["type"]]),
     color = scales::alpha(c("blue", "red", "dodgerblue"), 0.5), 
     fill = scales::alpha(c("blue", "red", "dodgerblue"), 0.5),
     opacity = 0.5
  ),
  junction = c("type", "id")
)

enhanced_sf = add_visual_param(
  layer = so_ii_hydro,
  visual_param = data.frame(
     type = unique(so.ii::so_ii_hydro[["type"]]),
     color = scales::alpha(c("blue", "red", "dodgerblue"), 0.5), 
     fill = scales::alpha(c("blue", "red", "dodgerblue"), 0.5),
     opacity = 0.8
  ),
  junction = "type"
)

# For sfc objects
enhanced_sfc = add_visual_param(
  layer = so_ii_limit,
  visual_param = data.frame(
     id = "perimeter",
     label = "perimeter",
     color = "white",
     fill = "transparent",
     opacity = 1
  )
)

}
\seealso{
Other interactive mapping: 
\code{\link{add_leaflet_layer}()},
\code{\link{map_leaflet_commune}()},
\code{\link{map_leaflet_multilayer}()},
\code{\link{set_provider}()}
}
\concept{interactive mapping}
