% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_leaflet_multilayer.R
\name{add_leaflet_layer}
\alias{add_leaflet_layer}
\title{Add a Spatial Layer to a Leaflet Map}
\usage{
add_leaflet_layer(
  map,
  layer,
  group,
  point_marker = "marker",
  show_popup = TRUE
)
}
\arguments{
\item{map}{leaflet map object (\code{leaflet} object) to which the layer will be
added.}

\item{layer}{\code{sf} object representing the spatial layer to add to the map.
This object should contain attributes for color, opacity, and fill.}

\item{group}{character string representing the group name for the layer.
This is used for the layers control in the Leaflet map, allowing users to
toggle the layer's visibility.}

\item{point_marker}{character string specifying the type of marker to use for
point geometries. Valid options are "marker", "circle", and "popup".
Defaults to "marker".}

\item{show_popup}{Logical. It indicates whether to display popups for
features in the layer. Defaults to \code{TRUE}.}
}
\value{
leaflet map object (\code{leaflet} object) with the added layer.
}
\description{
This function adds a spatial layer (e.g., polygons or polylines, or points)
to an existing Leaflet map, customizing its appearance with colors, weights,
opacity, and fill properties. It dynamically handles different geometry types
within the layer.
}
\details{
The function differentiates between polygon, polyline, and point geometries
within the \code{layer} object.
Polygons are added using \code{leaflet::addPolygons}, polylines are added using
\code{leaflet::addPolylines}, and points are added using either
\code{leaflet::addMarkers}, \code{leaflet::addCircleMarkers}, or \code{leaflet::addPopups},
based on the \code{point_marker} parameter.
The function also adds the layer's  legend to the map, displaying the unique
fill colors and corresponding labels from the layer's attributes (only for
non-point geometries).

The \code{layer} (sf object) provided to this function is expected to include the
following attributes in its associated \code{data.frame}:
\itemize{
\item color: A character or numeric vector specifying the color of the feature
(used for polygons and polylines).
\item opacity: A numeric value between 0 and 1 indicating the opacity of the
feature (used for polygons and polylines).
\item fill: A character or numeric vector specifying the fill color of the
feature (used for polygons).
\item label: A character vector providing a label or description for each feature
This label is used as the legend label for polygon and line geometries.
\item popup: If show_popup = TRUE, a character vector containing HTML-formatted
text
}
}
\examples{

\dontrun{
# Example usage:
map_bg = set_provider("ign_3d")
map = leaflet::leaflet() |>
 leaflet::addTiles(
     urlTemplate = map_bg[["provider"]],
     attribution = map_bg[["attribution"]],
     options = leaflet::tileOptions(opacity = 0.2)
)
map

map = add_leaflet_layer(
    map = map,
    layer = add_visual_param(
        layer = so_ii_limit,
        visual_param = data.frame(
            id = "perimeter",
            label = "perimeter",
            popup = "so-ii perimeter",
            color = "white",
            fill = "transparent",
            opacity = 1
        )
    ),
    group = "perimeter"
)
map

map = add_leaflet_layer(
    map = map,
    layer = add_visual_param(
        layer = so_ii_hydro,
        visual_param = data.frame(
            id = unique(so.ii::so_ii_hydro[["type"]]),
            label = unique(so.ii::so_ii_hydro[["type"]]),
            popup = unique(so.ii::so_ii_hydro[["type"]]),
            color = scales::alpha(c("blue", "red", "dodgerblue"), 0.5), 
            fill = scales::alpha(c("blue", "red", "dodgerblue"), 0.5),
            opacity = 0.5
        ),
        junction = c("type", "id")
    ),
    group = "perimeter"
)
map

random_points = data.frame(
    label = c("point1", "point2", "point3"),
    long = c(3.821011, 3.870760, 3.896732),
    lat = c(43.55250, 43.65147, 43.61877)
)

random_points = sf::st_as_sf(
    x = random_points,
    coords = c("long","lat"),
    crs = sf::st_crs(so_ii_hydro)
)

map = add_leaflet_layer(
    map = map,
    layer = add_visual_param(
        layer = random_points,
        visual_param = data.frame(
            id = unique(random_points[["label"]]),
            label = unique(random_points[["label"]]),
            color = NA, 
            fill = NA,
            opacity = 0.5,
            popup = sprintf("this is random \%s", random_points[["label"]])
        ),
        junction = "label"
    ),
    group = "random_points"
)
map
}
}
\seealso{
Other interactive mapping: 
\code{\link{add_visual_param}()},
\code{\link{map_leaflet_commune}()},
\code{\link{map_leaflet_multilayer}()},
\code{\link{set_provider}()}
}
\concept{interactive mapping}
