#' @title Create a linesep for kable
#' 
#' @param x vector, either numerical or logical, position for separation
#' @param n integer, length of result
#'
#' @return A character vector of linesep to be used un kable. 
#'
#' @export
#'
#' @encoding UTF-8
#' @author This is an adaptation of the function inset of the terra package.
#' 
#' @examples
#' 
#' temp = iris[sample(seq_len(nrow(iris)), 10),]
#' kable(temp, linesep = linesep(diff(as.integer(temp[["Species"]])) != 0))
#' kable(temp, linesep = linesep(temp[["Species"]][-1] != temp[["Species"]][-nrow(temp)]))
#' 
#' temp = temp[order(temp[["Species"]]), ]
#' kable(temp, linesep = linesep(cumsum(table(temp[["Species"]]))))
 
linesep = function(x, n) {
    x = if (is.logical(x)) which(x) else as.integer(x)
    if (missing(n)) n = max(x)
    result = rep("", n)
    result[x[x > 0]] = "\\midrule"
    result[n + x[x < 0]] = "\\midrule"
    return(result)
}
