#' @title Replace kable from kniter with some useful preset options
#' 
#' @param data object, something to be transform in a table
#' @param ...  some parameters that will be used in original kable
#'
#' @return Somthing to be used as a table in latex format
#'
#' @export
#'
#' @encoding UTF-8
#' 
#' @examples
#'
#' temp = head(iris)[c(5, 1:4)]
#' temp[["Species"]] = as.character(temp[["Species"]])
#' kable(temp)
#' temp = rbind(temp, c(Species = "mean", as.list(colMeans(temp[-1]))))
#' kable(temp, -1)
#' temp = rbind(temp, c("units", "mm", "mm", "mm", "mm"))
#' kable(temp, -1)
 
kable = function(data, ...) {
    knitr::kable(
        data,
        format = "latex",
        booktabs = TRUE,
        digits = 2,
        format.args = list(big.mark = " ", scientific = FALSE, digit = 2),
        ...
    ) |>
    kableExtra::kable_styling(position = "center")
}