#' @title Find the current version of some data
#' 
#' @param path character path to a directory where to find data
#' @param ... some extra parameters that will be passed to dir(path, ...)
#'
#' @return character path of the file corresponding the current version of the data
#'
#' @export
#'
#' @encoding UTF-8
#' 
#' @examples
#' 
#' \dontrun{
#' # To be added (soon)
#' }
 
current_version = function(path, ...) {
    path = as.character(path)[1]
    file.path(
        path,
        utils::head(sort(dir(path, ...), decreasing = TRUE), 1)
    )
}
