% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{so_ii_onrn}
\alias{so_ii_onrn}
\title{ONRN information for so-ii}
\format{
data.frame 78 rows, 23 variables
\describe{
\item{n_catnat}{Number of Cat Nat events}
\item{freq_sin}{Number of claims divided by number of contracts
for 1995 to 2018. freq_sin is calculated as the mean of freq_sin_min
and freq_sin_max (range for each category).}
\item{cost}{Cumulative cost of claims for 1995 to 2018. Cost is calculated
as the mean of cost_min and cost_max (range for each category).}
\item{cost_mean}{Mean cost of claims (cost divided by claims) for 1995 to
2018. cost_mean is calculated as the mean of cost_mean_min and
cost_mean_max (range for each category).}
\item{cost_hab}{Cost divided by the population for 1995 to 2018. cost_hab
is calculated as the mean of cost_hab_min and cost_hab_max (range for
each category).}
\item{ratio}{Cost divided by premium for 1995 to 2018. ratio is calculated
as the mean of cost_hab_min and cost_hab_max (range for each
category).}
\item{balance}{Cost minus premium for 1995 to 2018. This is an estimation
made by so-ii team by considering a mean premium for each habitant
of 24.92829 euro per habitant (total premium in 2018 divided by
total population)}
\item{ppri_year}{Year given for the last PPRI.}
\item{ppri_state}{State of the last PPRI.}
\item{ppri_state_sub}{Some details on the state of the last PPRI.}
\item{ppri_state_age}{State of the last PPRI for age information.}
\item{ppri_age_min}{Lower boundary for the age of the PPRI.}
\item{ppri_age_min}{Upper boundary for the age of the PPRI..}
}
}
\source{
\url{https://www.georisques.gouv.fr/articles-risques/acceder-aux-indicateurs-sinistralite}
}
\usage{
so_ii_onrn
}
\description{
A dataset containing part of the information available at the ONRN for so-ii
communities. The information chosen is exclusively related to floods. It is
mainly related to impacts and therefore to the claims in from the Cat-Nat
system. These data on claims are taken from the CCR, the others from the
gaspar database.
}
\keyword{datasets}
