% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{so_ii_catchment}
\alias{so_ii_catchment}
\title{Catchment areas of interest within the so-ii perimeter}
\format{
sf data.frame 15 rows, 4 variables
\describe{
\item{id}{id, from BD TOPAGE (corresponding to CdOh) or NA when catchment
is constructed by so-ii team.}
\item{name}{character, name of the catchment area in BD TOPAGE, or given
name for catchments constructed by so-ii team.}
\item{degre}{factor, importance of the catchment used to plot the
catchment areas with different levels of detail ("1", "2", "3").}
}
}
\source{
\url{http://bdtopage.eaufrance.fr/page/objectifs}
}
\usage{
so_ii_catchment
}
\description{
A dataset containing the official catchments areas of interest from the BD
TOPAGE within the so-ii perimeter. For degre = 3, the data are basically
what is found in BD TOPAGE. For degres 1 and 2, the data result from
sf::st_union of data of degre 3 to give a more synthetic representation.
}
\keyword{datasets}
