% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_so_ii.R
\encoding{UTF-8}
\name{map_so_ii}
\alias{map_so_ii}
\title{Plot a thematic map of so-ii}
\usage{
map_so_ii(
  dataset,
  dataset_legend = NULL,
  theme = c("none", "collectivity", "catchment", "catnat", "clc", "hydro", "onrn", "osm",
    "population"),
  theme_legend = FALSE,
  detail,
  year,
  scope = "so.ii",
  bar = TRUE,
  limit = TRUE,
  inset = NULL,
  path = NULL,
  add = FALSE,
  ...
)
}
\arguments{
\item{dataset}{sf object (or list of sf objects...), data to be plotted.
See details.}

\item{dataset_legend}{list of parameters (or list of list...) to be passed to
legend. See details.}

\item{theme}{character, choice for the theme (if any). See details.}

\item{theme_legend}{logical, should a legend be plotted for the theme.}

\item{detail}{character, detail for theme, depends on theme. See details.}

\item{year}{character, the year chosen for some themes. See details.}

\item{scope}{character, choice for the scope of the map. See details.}

\item{bar}{logical, should a bar be plotted for the dataset. See details.}

\item{limit}{logical, should the limit of so.ii be plotted for the dataset.
Default to TRUE.}

\item{inset}{character, managing if an inset is plotted.}

\item{path}{character, the name of the file to save the plot. Graphical
device is chosen depending on extension. See details.}

\item{add}{logical, should the plot be added to an existing one. Default to
FALSE.}

\item{...}{some parameters that will be used by plot (from sf) or by
add_bar (so.ii).}
}
\value{
Nothing useful.
}
\description{
Plot a thematic map of so-ii
}
\details{
\subsection{dataset specification}{
\itemize{
\item \code{dataset} can be directly a sf (or sfc), in which case only its geometry is
used. All parameters passed to plot comes from \code{...}.
\item if \code{dataset} is a list, each slot should be prepared so that to be call by
a \code{do.call(plot, slot)}. So it should have a slot named \code{x} and all slots useful
for plot.
}
}

\subsection{dataset_legend specification}{
\itemize{
\item \code{dataset_legend} can be directly a list of parameters that will be plot
through a \code{do.call(legend, dataset_legend)}. To be in this case, it is
checked if \code{dataset_legend} has a slot named \code{legend}.
\item Otherwise, it is considered as a list of legends parameters and
several legends are plotted.
}

By default, the dataset_legend is plotted in the "bottomright". It it has to
be changed a slot "x" is needed.
}

\subsection{theme specification}{

For the specification of detail, it depends on the theme chosen.
\itemize{
\item \strong{none}: perimeter of so_ii is plotted.
\item \strong{catchment}: The area of catchments are plotted with a scope
depending on detail. At least, a division between Lez and
Bassin de l'Or is plotted.
\item \strong{catnat}: Informations on the number of "Arrêtés Cat
Nat are provided at the scale of collectivities."
\item \strong{collectivty}: Boundaries of collectivities are plotted, more
some administrative informations depending on detail.
\item \strong{hydro}: The hydrophic network is plotted. Depending on
detail, only a part (rivers, canals, water bodies) or a degre of detail
is plotted.
\item \strong{onrn}: Informations on the claims coming from Cat Nat system
are plotted at the scale of the collectivities. With detail a selection
of the data is made, with year a selection of the period.
\item \strong{osm}: A tile from OSM is plotted.
\item \strong{population}: Informations on the population coming from
INSEE are plotted at the scale of the collectivities. With year a
selection of the period is made, with detail a selection of how
evolution between 2 years.
}
}

\subsection{detail specification}{

For the specification of detail, it depends on the theme chosen.
\itemize{
\item \strong{catchment}: detail must be chosen in "none", "1", "2", "3"
for levels of detail. If missing, "1" will be chosen.
\item \strong{catnat}: detail must be chosen in "inondation",
"submersion", or "nappe". If missing all type will be chosen and
aggregated before plotting.
\item \strong{clc}: detail must be chosen in "so.ii", "crop",
"both". If missing, "so.ii" will be chosen, and only information inside
so_ii_limit is plotted.
\item \strong{collectivity}: detail must be chosen in "none", "syble",
"symbo", "epci" or "syndicate". If missing, "none" will be chosen,
and only the boundaries of collectivities are plotted.
\item \strong{hydro}: detail must be chosen in "none", "1", "2", "3" for
levels of detail or "canal", "river", "waterbody" for types of
hydrographic elements. If missing, "none" will be chosen, and
everything is plotted.
\item \strong{onrn}: detail must be chosen in "n_catnat", "freq_sin",
"cost", "cost_hab", "cost_mean", "ratio", "balance", "ppri_year".
\item \strong{population}: detail must be chosen in "absolute",
"relative". It used only when more than one year is provided to plot
aither absolute or relative evolution.
}
}

\subsection{year specification}{

For the specification of year, it depends on the theme chosen.
\itemize{
\item \strong{catnat}: year corresponds to the year of data. If 2 or more
years are given, the sum of the period corresponding to the range of
given years is plotted. If missing, the whole available period is
plotted.
\item \strong{population}: year corresponds to the year of data. If
missing, last available year is plotted. If 2 or more years are
provided an analysis of the evolution between the range of given
years is plotted.
}
}

\subsection{inset specification}{

If inset is not NULL, an inset will be plotted, depending on the value of
as.character(inset). Non-case sensitive partial matching is used, with "é"
interpreted as "e".
\itemize{
\item \strong{so-ii}: scope perimeter is located within so-ii. Only
useful when scope is less than so-ii.
\item \strong{department}: scope perimeter is located within Hérault
departement, if inset may be interpreted as "department", "département",
"hérault", "34".
\item \strong{region}: scope perimeter is located within Occitanie region,
if inset may be interpreted as "région", "Occitanie", "76" (INSEE code
for Occitanie region).
\item \strong{nation}: scope perimeter is located within the metropolitean
part of France, if inset may be interpreted as "France", "métropole",
"nation".
}

If all other cases, nothing is added.
}

\subsection{scope specification}{

The scope should be either:
\itemize{
\item \strong{so.ii}: the whole perimiter of so.ii is chosen. This is
default value.
\item \strong{vector of INSEE codes of collectivities in so.ii}: a
perimeter is build with those collectivies. Only valid codes are taken
into account. If none is chosen, a warning is dropped, and default
value is used.
}

path specification

Depending on the extension a device is chosen.
\itemize{
\item \strong{pdf}: grDevices::cairo_pdf
\item \strong{png}: grDevices::png
\item \strong{jpg}: grDevices::jpg
\item \strong{svg}: grDevices::svg
}

If path is NULL, standard plotting is used. If an extension is not managed,
an error is raised.
}
}
\examples{

\dontrun{
# To be added (soon)
}
}
