% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_margin.R
\encoding{UTF-8}
\name{add_margin}
\alias{add_margin}
\title{Replace addmargins with treatment for data.frame}
\usage{
add_margin(x, name, output = c("normal", "data.frame"), ...)
}
\arguments{
\item{x}{either a matrix, an array or a data.frame}

\item{name}{vector, if x is a data.frame, gives the poistion of what should
be considered as names (and so not pass to addmargins).}

\item{output}{character, gives the type of output, either as.is or a
data.frame.}

\item{...}{arguments that will be used for addmargins}
}
\value{
A table, array or data.frame with margins added.
}
\description{
Replace addmargins with treatment for data.frame
}
\examples{

add_margin(head(iris), 5)
add_margin(head(iris), 5, "data.frame")
add_margin(head(iris), 5, FUN = list("total" = sum))

x = data.frame(
    gender = sample(c("H", "F"), 20, replace = TRUE),
    region = sample(c("east", "west", "south", "north"), 20, replace = TRUE),
    wealth = round(runif(20) * 10000),
    size = round(runif(20) * 50 + 150)
)
add_margin(head(x), 1:2, margin = 1, FUN = list(mean = mean))
}
