% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_inset.R
\encoding{UTF-8}
\name{add_inset}
\alias{add_inset}
\title{Add an inset within a map}
\usage{
add_inset(x, y, ratio = 1/5, add = TRUE, ...)
}
\arguments{
\item{x}{should be a sf object or at least readable by sf::st_geometry.}

\item{y}{should be a sf object or at least readable by sf::st_bbox.}

\item{ratio}{numeric, how big should be the inset relative to the whole map
or to y. See details.}

\item{add}{loical, should the inset be added to an existing plot.}

\item{...}{some parameters that will be used by sf::plot}
}
\value{
sf geometry transformed to be placed in the good loaction in the map.
}
\description{
Add an inset within a map
}
\details{
If add = TRUE, the location is calculated through the extent of current map.
If add = FALSE, the location is calcultaed through the extent of y.

The function is based on the facility to rescale and translate sf object.
}
\examples{

library(sf)
so.ii::map_so_ii()
inset = add_inset(
  so.ii::so_ii_inset[c("region", "so-ii"), ],
  so.ii::so_ii_limit,
  col = c("gray", "red"), border = c(NA, "red"), lwd = 1:2
)
}
