## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----message=FALSE------------------------------------------------------------
library(sf)
library(so.ii)

# Create a sample spatial object 
data = st_as_sf(
  data.frame(x = c(3.7, 3.8, 4.0), y = c(43.6, 43.7, 43.65)), 
  coords = c("x", "y")
)

# Generate a basic map
map_so_ii(dataset = data, pch = 19, col = "red")

## -----------------------------------------------------------------------------
map_so_ii(
  dataset = data, pch = 19, col = "red",
  dataset_legend = list(
    x = "bottomright",
    legend = "random points",
    col = "red",
    pch = 19
  )
)

## -----------------------------------------------------------------------------
map_so_ii(
  dataset = data, pch = 19, col = "red", 
  theme = "catchment", 
  detail = "2"
)

## -----------------------------------------------------------------------------
map_so_ii(
  dataset = data, pch = 19, col = "red", 
  theme = "catchment", 
  detail = "2",
  theme_legend = TRUE
)

## -----------------------------------------------------------------------------
map_so_ii(
  dataset = data, pch = 19, col = "red",
  dataset_legend = list(
    x = "bottomright",
    legend = "random points",
    col = "red",
    pch = 19,
    title = "MyRandomDataset"
  ), 
  theme = "catchment", 
  detail = "2",
  theme_legend = TRUE
)

## -----------------------------------------------------------------------------
map_so_ii(
  dataset = data, pch = 19, col = "red", 
  theme = "clc", 
  detail = "so.ii",
  theme_legend = TRUE
)

## -----------------------------------------------------------------------------
map_so_ii(
  dataset = data, pch = 19, col = "red", 
  theme = "population", 
  year = "2019",
  theme_legend = TRUE
)

## -----------------------------------------------------------------------------
map_so_ii(
  dataset = data, pch = 19, col = "red", 
  theme = "population", 
  year = c("2009", "2019"),
  theme_legend = TRUE
)

## -----------------------------------------------------------------------------
map_so_ii(
  dataset = data, pch = 19, col = "red", 
  scope = "34255",
  inset = "so-ii",
)

## -----------------------------------------------------------------------------
plot(
  so_ii_inset[so_ii_inset$scope == "Hérault",], 
  col = "white", 
  axes = TRUE, 
  reset = FALSE
)
map_so_ii(
  dataset = data, pch = 19, col = "red",
  dataset_legend = list(
    x = "bottomright",
    legend = "random points",
    col = "red",
    pch = 19
  ), 
  theme = "hydro",
  theme_legend = TRUE,
  add = TRUE
)

