#' @title Create a leaflet map with popup information at commune level
#' 
#' @details
#' `dataset` should contain valiud html content in `popup` variable.
#' 
#' @param dataset sf object, data to be plotted
#'
#' @return Nothing useful.
#' 
#' @export map_leaflet_commune
#' 
#' @examples
#' 
#' \dontrun{
#' dataset = so.ii::so_ii_collectivity
#' dataset[["popup"]] = paste(
#'  dataset[["commune_name"]],
#'  sprintf("(%s hab)", formatC(so_ii_population[,"2019"], big.mark = " ", format = "d"))
#' )
#' map_leaflet_commune(dataset)
#' }


map_leaflet_commune = function(dataset) {
    leaflet::leaflet() |>
    leaflet::addTiles(
        urlTemplate = paste0(
        "https://data.geopf.fr/wmts?",
        "REQUEST=GetTile&SERVICE=WMTS&VERSION=1.0.0",
        "&STYLE=normal",
        "&TILEMATRIXSET=PM",
        "&FORMAT=image/jpeg",
        "&LAYER=ORTHOIMAGERY.ORTHOPHOTOS",
        "&TILEMATRIX={z}",
        "&TILEROW={y}",
        "&TILECOL={x}"
        ),
        attribution = "IGN-F/Geoportail",
        options = leaflet::tileOptions(opacity = 0.2)) |>
    leaflet::addPolygons(
        data = so.ii::so_ii_limit[0],
        color = "#EEAA86", 
        weight = 2,
        smoothFactor = 0.5,
        opacity = 1.0,
        fillColor = "transparent"
    ) |>
    leaflet::addPolygons(
        data = dataset[0],
        color = "#EEAA86", 
        weight = 0.5,
        smoothFactor = 0.5,
        opacity = 1.0,
        fillColor = "#fef9e9", 
        fillOpacity = 0.75,
        highlightOptions = leaflet::highlightOptions(
            color = "dodgerblue", 
            weight = 2,
            bringToFront = TRUE
        ),
        popup = dataset[["popup"]]
    )
}
