#' @title Transform ods table presence in md table (for Mattermost)
#'
#' @param x character or data.frame, path of the ods table or the table itself
#'
#' @return character, md version of table behind x.
#' 
#' @export
#'
#' @encoding UTF-8
 
format_presence = function(x) {
    result = if (is.character(x)) readODS::read_ods(x[1]) else x
    result[]  = lapply(result, gsub, pattern = "B", replacement = "**B**")
    result[]  = lapply(result, gsub, pattern = "C", replacement = "*C*")
    knitr::kable(result, align = c("l", rep("c", length(result) - 1)))
}
