#' @title Estimate frequency of Cat Nat events
#' 
#' @param commune factor, commune
#' @param period POSIXct, a date for the event
#' @param hazard factor, type of hazard
#' @param period_format character, format to extract information from period
#'
#' @return array fivving frequency of Cat Nat events with 3 dimensions
#'      (commune, period, hazard)
#'
#' @export
#'
#' @encoding UTF-8
#' 
#' @examples
#' 
#' \dontrun{
#' # To be added (soon)
#' }
 
estimate_catnat_freq = function(
    commune,
    period,
    hazard,
    period_format = "%Y"
) {
    period = format(as.Date(period), period_format)
    period_levels = switch(
        EXPR = period_format,
        "%Y" = formatC(
            1982:as.integer(format(Sys.Date(),"%Y")),
            width = 4, format = "d", flag = "0"
        ),
        "%m" = formatC(1:12, width = 2, format = "d", flag = "0"),
        sort(unique(as.character(period)))
    )
    result = data.frame(
        commune = commune,
        period = factor(period, levels = period_levels),
        hazard = hazard
    )
    result = table(result)
    class(result) = "array"
    return(result)
}
