#' Color and label for CLC
#'
#' A dataset proposing default colors and labels for plotting CLC
#'
#' @format data.frame 5 rows, 3 variables
"clc_color"

#' Catchment areas of interest within the so-ii perimeter
#'
#' A dataset containing the official catchments areas of interest from the BD 
#' TOPAGE within the so-ii perimeter. For degre = 3, the data are basically
#' what is found in BD TOPAGE. For degres 1 and 2, the data result from
#' sf::st_union of data of degre 3 to give a more synthetic representation.
#'
#' @format sf data.frame 15 rows, 4 variables
#' \describe{
#'   \item{id}{id, from BD TOPAGE (corresponding to CdOh) or NA when catchment
#'      is constructed by so-ii team.}
#'   \item{name}{character, name of the catchment area in BD TOPAGE, or given
#'      name for catchments constructed by so-ii team.}
#'   \item{degre}{factor, importance of the catchment used to plot the
#'      catchment areas with different levels of detail ("1", "2", "3").}
#' }
#'
#' @source \url{http://bdtopage.eaufrance.fr/page/objectifs}
"so_ii_catchment"

#' Number of Cat Nat events for the municipalities of so-ii
#'
#' A dataset containing the number of Cat Nat events (linked to flood) by year
#' and so-ii municipality according to the GASPAR database.
#' 
#' Last update: 2023-10-17
#'
#' @format array with 3 dimensions
#' \describe{
#'   \item{first}{commune as in so_ii_scope}
#'   \item{second}{year of Cat Nat events}
#'   \item{third}{type of hazard}
#' }
#'
#' @source \url{https://www.georisques.gouv.fr/donnees/bases-de-donnees/base-gaspar} # nolint
"so_ii_catnat"

#' CLC information for so-ii
#'
#' A dataset containing the Corine Land Cover information on so-ii.
#'
#' @format sf data.frame 1337 rows, 2 variables
#' \describe{
#'   \item{clc_2018}{character, classification from CLC 2018}
#'   \item{color}{character, default color to be used to plot so_ii_clc}
#' }
"so_ii_clc"

#' CLC information for a crop zone around so-ii
#'
#' A dataset containing the Corine Land Cover information on so-ii. A row is
#' added to CLC to plot also the sea. It has code "000".
#'
#' @format sf data.frame 1337 rows, 2 variables
#' \describe{
#'   \item{clc_2018}{character, classification from CLC 2018}
#'   \item{color}{character, default color to be used to plot so_ii_clc}
#' }
"so_ii_clc_crop"

#' Spatial definition of collectivities included in so-ii
#'
#' A dataset containing the spatial definition of all collectivities
#' included in so-ii and some administrative informations.
#'
#' @details
#' Basically this dataset is obtained as a selection from the layer
#' COMMUNE in ADMIN EXPRESS, more a renaming of variables. It is then added
#' information from EPCI in ADMIN EXPRESS and the membership to SYBLE and
#' SYMBO.
#'
#' @format sf data.frame 78 rows, 11 variables
#' \describe{
#'   \item{commune_name}{character, INSEE code of the collectivity}
#'   \item{syble}{logical, membership in SYBLE}
#'   \item{symbo}{logical, membership in SYMBO}
#'   \item{commune_name}{character, official name of the collectivity}
#'   \item{commune_name_cap}{character, official capitalized name of the
#'          collectivity}
#'   \item{departement}{character, INSEE code of the departement of the
#'          collectivity}
#'   \item{region}{character, INSEE code of the region of the
#'          collectivity}
#'   \item{epci}{character, INSEE code of the EPCI of the collectivity}
#'   \item{epci_name}{character, Name of the EPCI of the collectivity}
#'   \item{epci_nature}{character, Nature of the EPCI of the collectivity}
#' }
#'
#' @source \url{https://www.data.gouv.fr/fr/datasets/admin-express/}
"so_ii_collectivity"

#' Hydrographic network within the so-ii perimeter
#'
#' A dataset containing the official hydrographic network from the BD TOPAGE
#' within the so-ii perimeter.
#'
#' @format sf data.frame 125 rows, 4 variables
#' \describe{
#'   \item{id}{id, from BD TOPAGE (corresponding to CdOh)}
#'   \item{name}{character, name of the hydrographic elements in the BD TOPAGE}
#'   \item{degre}{factor, level of importance of the hydrographic element
#'      used to plot the hydrographic network with different levels of
#'      detail ("1", "2", "3").}
#'   \item{type}{factor, type of hydrographic element ("canal", "river",
#'      "waterbody")}
#' }
#'
#' @source \url{http://bdtopage.eaufrance.fr/page/objectifs}
"so_ii_hydro"

#' Inset to help localisation of the so-ii perimeter
#'
#' A sf dataset containing 4 simplified geometries of France, Occitanie,
#' Hérault, and so-ii perimeter. rownames are provided with "nation", "region",
#' "department", "so.ii".
#'
#' @format sf data.frame 4 rows, 1 variable
#' \describe{
#'   \item{scope}{character, names of the scope}
#' }
#'
#' @source \url{http://bdtopage.eaufrance.fr/page/objectifs}
"so_ii_inset"

#' Spatial perimeter of so-ii
#'
#' A dataset containing the perimeter of so-ii.
#'
#' Basically, this dataset is obtained as
#' \code{sf::st_union(so_ii_commune)}
#'
#' @format sfc_POLYGON of length 1
"so_ii_limit"

#' Spatial definition of districts of Montpellier city
#'
#' A dataset containing the spatial definition of all districts
#' for Montpellier.
#'
#' @format sf data.frame 31 rows, 2 variables
#' \describe{
#'   \item{district}{character, id of each district as given by montpellier3m}
#'   \item{district_name}{character, name of each district}
#'   \item{district_group}{character, how districts are grouped by montpellier3m}
#' }
#'
#' @source \url{https://data.montpellier3m.fr/dataset/sous-quartiers-de-montpellier}
"so_ii_montpellier"

#' Local collectivities included in so-ii
#'
#' A dataset containing the INSEE code of all local collectivities
#' (communes) included in so-ii
#'
#' @format a vector of 78 INSEE code
"so_ii_scope"

#' ONRN information for so-ii
#'
#' A dataset containing part of the information available at the ONRN for so-ii
#' communities. The information chosen is exclusively related to floods. It is
#' mainly related to impacts and therefore to the claims in from the Cat-Nat
#' system. These data on claims are taken from the CCR, the others from the
#' gaspar database.
#'
#' @format data.frame 78 rows, 23 variables
#' \describe{
#'   \item{n_catnat}{Number of Cat Nat events}
#'   \item{freq_sin}{Number of claims divided by number of contracts
#'      for 1995 to 2018. freq_sin is calculated as the mean of freq_sin_min
#'      and freq_sin_max (range for each category).}
#'   \item{cost}{Cumulative cost of claims for 1995 to 2018. Cost is calculated
#'      as the mean of cost_min and cost_max (range for each category).}
#'   \item{cost_mean}{Mean cost of claims (cost divided by claims) for 1995 to
#'      2018. cost_mean is calculated as the mean of cost_mean_min and
#'      cost_mean_max (range for each category).}
#'   \item{cost_hab}{Cost divided by the population for 1995 to 2018. cost_hab
#'      is calculated as the mean of cost_hab_min and cost_hab_max (range for
#'      each category).}
#'   \item{ratio}{Cost divided by premium for 1995 to 2018. ratio is calculated
#'      as the mean of cost_hab_min and cost_hab_max (range for each
#'      category).}
#'   \item{balance}{Cost minus premium for 1995 to 2018. This is an estimation
#'      made by so-ii team by considering a mean premium for each habitant
#'      of 24.92829 euro per habitant (total premium in 2018 divided by
#'      total population)}
#'   \item{ppri_year}{Year given for the last PPRI.}
#'   \item{ppri_state}{State of the last PPRI.}
#'   \item{ppri_state_sub}{Some details on the state of the last PPRI.}
#'   \item{ppri_state_age}{State of the last PPRI for age information.}
#'   \item{ppri_age_min}{Lower boundary for the age of the PPRI.}
#'   \item{ppri_age_min}{Upper boundary for the age of the PPRI..}
#' }
#'
#' @source \url{https://www.georisques.gouv.fr/articles-risques/acceder-aux-indicateurs-sinistralite}
"so_ii_onrn"

#' Population for so-ii
#'
#' A dataset containing the population of commune in so-ii according to INSEE.
#'
#' @format numeric matrix 78 rows, 33 columns
#' \describe{
#'   \item{row}{commune as in so_ii_scope}
#'   \item{column}{year}
#' }
#'
#' @source \url{https://www.insee.fr/fr/statistiques/2522602}
"so_ii_population"