test_that("Test get_hydraulic_damage",
    {
        # create test matrices
        dam = list()
        dam[["absolute_room"]][["room_1"]][["total"]] = matrix(
            c(0, 0, 0, 0, 1000, 2000, 0, 1500, 2500),
            ncol = 3, byrow = FALSE,
            dimnames = list(h = c(0, 10, 20), d = c(0, 12, 40))
        )
        dam[["absolute_external"]][["wall_01"]][["total"]] = matrix(
            c(0, 0, 0, 0, 100, 200, 0, 150, 250),
            ncol = 3, byrow = FALSE,
            dimnames = list(h = c(0, 10, 20), d = c(0, 12, 40))
        )
        dam[["absolute_external"]][["wall_02"]][["total"]] = matrix(
            c(0, 0, 0, 0, 100, 200, 0, 150, 250),
            ncol = 3, byrow = FALSE,
            dimnames = list(h = c(0, 10, 20), d = c(0, 12, 40))
        )
        dam[["absolute_external"]][["wall_03"]][["total"]] = matrix(
            c(0, 0, 0, 0, 200, 400, 0, 300, 500),
            ncol = 3, byrow = FALSE,
            dimnames = list(h = c(0, 10, 20), d = c(0, 12, 40))
        )
        exposition = list(facade_1 = list(external = c("wall_01", "wall_02")),
            facade_2 = list(external = c("wall_03"))
        )

        # test h thresholds
        hmax = c(room_1 = 0, room_1 = 0.005, room_1 = 0.02, room_1 = 0.12, room_1 = 10.0)
        damage = get_hydraulic_damage(hmax, dam, NULL, threshold_height = 2)
        result = matrix(
            c(0, 0, 0, 1200, 2000, 3200),
            nrow = 1,
            dimnames = list("damage", c(names(hmax), "total"))
        )
        expect_equal(damage, result)

        # test unknown room
        hmax = c(room_5 = 0.1)
        damage = get_hydraulic_damage(hmax, dam, NULL)
        expect_true(all(is.na(damage)))

        # test multiple externals
        hmax = c(facade_1 = 0.15, facade_2 = 0.12)
        damage = get_hydraulic_damage(hmax, dam, exposition)
        result = matrix(
            c(300, 240, 540),
            nrow = 1,
            dimnames = list("damage", c(names(hmax), "total"))
        )
        expect_equal(damage, result)

        # test reference function >12h
        colnames(dam[["absolute_room"]][["room_1"]][["total"]])[[2]] = 20
        hmax = c(room_1 = 0.1)
        expect_error(get_hydraulic_damage(hmax, dam, NULL))

        # test d threshold
        hmax = c(room_1 = 0.14)
        damage = get_hydraulic_damage(hmax, dam, NULL, threshold_duration = 20)
        result = matrix(
            c(1400, 1400),
            nrow = 1,
            dimnames = list("damage", c(names(hmax), "total"))
        )
        expect_equal(damage, result)

        # testing with a model
        model = adu_t
        selection = grepl("^room", levels(model[["data_table"]][["room"]][["room"]]))
        room = levels(model[["data_table"]][["room"]][["room"]])[selection]
        damage = model[["dam_room_wall"]][c("absolute_room", "absolute_external")]
        exposition = list(
            facade = list(
                external =  names(adu_t[["dam_room_wall"]][["absolute_external"]])
            )
        )
        h_max_by_room = rep(0.005, length(room) + 1)
        names(h_max_by_room) = c(room, "facade")

        result = expect_no_error(
            get_hydraulic_damage(
                h_max_by_room = h_max_by_room, 
                damage = damage, 
                exposition = exposition,
                threshold_height = 1
            )
        )
        expect_type(result, "double")
        expect_true(is.matrix(result))
        expect_length(result, length(room) + length(exposition) + 1)
        expect_in(
            colnames(result), 
            c(room[grepl("room", room)], names(exposition), "total")
        )
        expect_false(any(is.na(result)))
    }
)