test_that("Test generate_limnigraph",
    {
        # Simple
        l_0 = expect_no_error(
            generate_limnigraph(
                model = adu_t,
                time = c(0, 1000, 2000),
                depth = cbind(facade = c(0, 1, 0)),
                exposition = list(facade = list(external = c("wall_A"))),
                verbose = FALSE
            )
        )

        # Simple more verbose
        l_1 = expect_no_error(
            generate_limnigraph(
                model = adu_t,
                time = c(0, 1000, 2000),
                depth = cbind(facade = c(0, 1, 0)),
                exposition = list(facade = list(external = c("wall_A"))),
                verbose = FALSE
            )
        )

        expect_identical(l_0, l_1)

        # Complex
        l = expect_no_error(
            generate_limnigraph(
                model = adu_t,
                time = c(0, 54, 108),
                depth = cbind(facade_1 = c(0, 3, 0), facade_2 = c(0, 0, 0)),
                exposition = list(
                    facade_1 = list(external = c("wall_A")),
                    facade_2 = list(external = c("wall_B"))),
                verbose = FALSE
            )
        )

        # Errors handling
        expect_error(
            generate_limnigraph(
                model = adu_t,
                time = c(0, 1000),
                depth = cbind(facade = c(0, 1, 0)),
                exposition = list(facade = list(external = c("wall_A"))),
                verbose = FALSE
            ),
            "'time' and 'depth' do not have compatible lengths."
        )

        expect_error(
            generate_limnigraph(
                model = adu_t,
                time = c(0, 1000, 2000),
                depth = c(0, 1, 0),
                exposition = list(facade = list(external = c("wall_A"))),
                verbose = FALSE
            ),
            "'depth' and 'exposition' names must be matching"
        )

        expect_error(
            generate_limnigraph(
                model = adu_t,
                time = c(0, 1000, 2000),
                depth = cbind(facade = c(0, 1, 0)),
                exposition = list(facade = list(external = c("wall_J"))),
                verbose = FALSE
            ),
            "Incorrect wall names"
        )
    }
)
