test_that("Test extract_id",
    {
        x = list(
            loc = list(ID = "LOCAL"),
            glob = list(ID = "GLOBAL"),
            generic = list(ID = "LOCAL", OPTIONAL = "o_loc", MANDATORY = "m_loc"),
            generic = list(ID = "GLOBAL", OPTIONAL = "o_glob", MANDATORY = "m_glob"),
            d = list()
        )

        # One level
        expect_equal(extract_id(x), c("loc", "m_loc", "o_loc"))
        expect_equal(extract_id(x, "GLOBAL"), c("glob", "m_glob", "o_glob"))


        # Two levels
        expect_equal(extract_id(list(x)), character())
        expect_equal(extract_id(list(x), "GLOBAL"), c("glob", "m_glob", "o_glob"))

        # Pathological cases
        expect_equal(extract_id(list()), character())
        expect_equal(extract_id(list(), "GLOBAL"), character())
        
        expect_equal(extract_id(list(list())), character())
        expect_equal(extract_id(list(list()), "GLOBAL"), character())

        x = list(generic = list(ID = "LOCAL"))
        expect_equal(extract_id(x), character())

        x = list(generic = list(ID = "GLOBAL"))
        expect_equal(extract_id(x, "GLOBAL"), character())
    }
)


