test_that("Test analyse_hydraulic",
    {
        # declaring input and output paths
        model = adu_t
        flood = expect_no_message(
            generate_limnigraph(
                model = model,
                time = c(0, 54, 108),
                depth = cbind(
                    facade_1 = c(0, 1, 0),
                    facade_2 = rep(0, 3)
                ),
                exposition = list(
                    facade_1 = list(external = c(
                        "wall_A", "wall_C", "wall_D",
                        "wall_E", "wall_F", "wall_G"
                    )),
                    facade_2 = list(external = c("wall_B", "wall_H"))
                ),
                verbose = FALSE
            )
        )

        hydraulic = expect_no_error(
            analyse_hydraulic(
                model = model,
                limnigraph = flood,
                opening_scenario = "close",
                dt_max = 0.5,
                Cd = 0.42,
                sim_id = "integrated_model",
                stage = "hydraulic",
                verbose = FALSE
            )
        )

        expect_type(hydraulic, "list")
        expect_s3_class(hydraulic, "hydraulic")
        expect_in(names(hydraulic), c("z", "h", "eQ", "eS", "ve", "vo", "hmax"))
        expect_failure(expect_contains(names(hydraulic), "damage"))

        # testing internal call to function get_hydraulic_damage()
        hydraulic = expect_no_error(
            analyse_hydraulic(
                model = model,
                limnigraph = flood,
                opening_scenario = "close",
                dt_max = 0.5,
                Cd = 0.42,
                sim_id = "integrated_model",
                stage = c("hydraulic","damaging"),
                verbose = FALSE
            )
        )
        
        expect_contains(names(hydraulic), "damage")
        expect_type(hydraulic[["damage"]], "double")
        expect_true(is.matrix(hydraulic[["damage"]]))
        expect_length(
            hydraulic[["damage"]], 
            length(model[["data_table"]][["room"]][["room"]]) + length(flood[["exposition"]])
        )
        expect_in(
            colnames(hydraulic[["damage"]]), 
            c(
                levels(
                    model[["data_table"]][["room"]][["room"]]
                )[grepl("room", model[["data_table"]][["room"]][["room"]])], 
                names(flood[["exposition"]]), 
                "total"
            )
        )
        expect_false(any(is.na(hydraulic[["damage"]])))
    }
)
