test_that("Test adjust_h_abs",
    {
        data_table = list(
            storey = data.frame(
                storey = factor("storey")
            ),
            room = data.frame(
                storey = factor("storey"),
                room = factor("room")
            ),
            wall = data.frame(
                room = factor("room"),
                id_wall = factor("wall")
            ),
            opening = data.frame(
                id_wall = factor("wall")
            ),
            coating = data.frame(
                id_wall = factor("wall")
            ),
            furniture = data.frame(
                room = factor("room")
            )
        )
        
        base_expected =expected = list(
            storey = data.frame(
                storey = factor("storey"),
                H = 0,
                H_abs = 0
            ),
            room = data.frame(
                storey = factor("storey"),
                room = factor("room"),
                H = 0,
                H_abs = 0
            ),
            wall = data.frame(
                room = factor("room"),
                id_wall = factor("wall"),
                H = 0,
                H_abs = 0
            ),
            opening = data.frame(
                id_wall = factor("wall"),
                H = 0,
                H_abs = 0
            ),
            coating = data.frame(
                id_wall = factor("wall"),
                H = 0,
                H_abs = 0
            ),
            furniture = data.frame(
                room = factor("room"),
                H = 0,
                H_abs = 0
            )
        )
        
        # All H empty in data_table
        expect_equal(adjust_h_abs(data_table), expected)

        # All H empty in data_table & h_ref defined
        h_ref = 10
        expected = lapply(expected, function(x){x[["H_abs"]] = h_ref; return(x)})
        expect_equal(adjust_h_abs(data_table, h_ref = h_ref), expected)

        # H defined for storey
        data_table[["storey"]][["H"]] = expected[["storey"]][["H"]] = 10
        expect_equal(adjust_h_abs(data_table), expected)

        # H defined for storey and room
        data_table[["room"]][["H"]] = expected[["room"]][["H"]] = 10
        expected[-1] = lapply(expected[-1], function(x){x[["H_abs"]] = 20; return(x)})
        expect_equal(adjust_h_abs(data_table), expected)

        # all H defined (and non zero)
        data_table[["wall"]][["H"]] = expected[["wall"]][["H"]] = 10
        data_table[["opening"]][["H"]] = expected[["opening"]][["H"]] = 10
        data_table[["coating"]][["H"]] = expected[["coating"]][["H"]] = 10
        data_table[["furniture"]][["H"]] = expected[["furniture"]][["H"]] = 10

        expected[["wall"]][["H_abs"]] = 30
        expected[["opening"]][["H_abs"]] = 40
        expected[["coating"]][["H_abs"]] = 40
        expected[["furniture"]][["H_abs"]] = 30
        expect_equal(adjust_h_abs(data_table), expected)

        # h_abs = "room"
        expected[["storey"]][["H"]] = expected[["room"]][["H"]] = 0
        expected[["storey"]][["H_abs"]] = expected[["room"]][["H_abs"]] = 00
        expected[["wall"]][["H_abs"]] = expected[["wall"]][["H"]]
        expected[["opening"]][["H_abs"]] = expected[["opening"]][["H"]] + expected[["wall"]][["H"]]
        expected[["coating"]][["H_abs"]] = expected[["opening"]][["H"]] + expected[["wall"]][["H"]]
        expected[["furniture"]][["H_abs"]] = expected[["furniture"]][["H"]]
        expect_equal(adjust_h_abs(data_table, h_abs = "room"), expected)
        expect_equal(adjust_h_abs(data_table, h_abs = "room", h_ref = 50), expected)

        # h_abs = "component"
        expect_equal(adjust_h_abs(data_table, h_abs = "component", h_ref = 50), base_expected)
    }
)


