% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_hydraulic_input.R
\name{prepare_hydraulic_input}
\alias{prepare_hydraulic_input}
\title{Extract hydraulic input data from model}
\usage{
prepare_hydraulic_input(
  model,
  exposition,
  opening_scenario,
  initial_water_depth_interior =
    getOption("floodam_building_hydraulic_initial_water_depth_interior"),
  discharge_coefficient = getOption("floodam_building_hydraulic_discharge_coefficient"),
  clearance = getOption("floodam_building_hydraulic_close_opening_clearance"),
  permeability = c("under", "side", "both"),
  verbose = getOption("floodam_building_verbose")
)
}
\arguments{
\item{model}{an object of class model}

\item{exposition}{list, contains list of \code{facade} exposed to the flood event.
Each \code{facade} is a list of named vectors of the walls exposed in the same
way. Vectors are named after the \code{external} they belong to in the model.}

\item{opening_scenario}{character, one of the following options: "open",
"close", "combine".}

\item{initial_water_depth_interior}{numeric, initial water depth in each room in meters, default to
getOption("floodam_building_hydraulic_initial_water_depth_interior")}

\item{discharge_coefficient}{numeric, discharge coefficient for each opening, default to
getOption("floodam_building_hydraulic_discharge_coefficient")}

\item{clearance}{numeric, measurement of the opening gap clearance, default to
getOption("floodam_building_hydraulic_close_opening_clearance")}

\item{permeability, }{character, optional; if water goes through the \code{side} of
the opening or \code{under} or \code{both}. Default to \code{under}, can be \code{side} or
\code{both}}

\item{verbose}{boolean, will floodam tells what it is doing, default to getOption("floodam_building_verbose")}
}
\value{
component hydraulic of the model
}
\description{
Extract hydraulic input data from model
}
\details{
This function creates data.frames with data on the openings for the hydraulic module. It creates one for each scenario \code{open} \code{close} \code{combine}
}
