% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_hydraulic.R
\name{plot.hydraulic}
\alias{plot.hydraulic}
\title{plot hydraulics.}
\usage{
\method{plot}{hydraulic}(
  x,
  output_dir = ".",
  device = "display",
  view = c("height", "discharge"),
  selection = "all",
  ...
)
}
\arguments{
\item{x}{an object of class hydraulic}

\item{output_dir}{character, path directory where output is saved. Default to
current directory}

\item{device, }{character, defines way of plotting. Can only be one device at
a time. If \code{display} is selected only one view can be shown at a time}

\item{view, }{vector of character, defines which view shall be plotted
Three options: "height", "discharge", "level"}

\item{selection}{vector, select the objects you want to plot either rooms or
facades or openings}

\item{...}{some extra parameters (unused)}
}
\value{
Nothing
}
\description{
plot hydraulics.
}
\details{
This is a new method for the plot function. It can be used to display graphs
or save graphs in different formats (\code{.png} and \code{.pdf}). The \code{.png} is in a
lower resolution than \code{.pdf} but is much lighter.

3 differents views are proposed:
\itemize{
\item \strong{height}: it represents the evolution of water height (m) for each room, the
reference being the elevation of each room.
\item \strong{level}: it represents the evolution of water height (m) for each room, the
reference being the elevation of the whole model.
\item \strong{discharge}: it represents the evolution of discharge (m³/s) for each
opening.
}
}
\examples{

# declaring input and output paths
model = adu_t

# generate limnigraph
flood = generate_limnigraph(
	 model = model,
  time = c(0, 300, 900),
  depth = cbind(facade = c(0, 3, 0)),
  exposition = list(
    facade = list(external = c("wall_A", "wall_B", "wall_C", "wall_D", "wall_E",
		"wall_F", "wall_G", "wall_H")))
)

hydraulic = analyse_hydraulic(
	model = model,
	limnigraph = flood,
	opening_scenario = "close",
	sim_id = "test",
	stage = "hydraulic"
)

plot(hydraulic)
plot(hydraulic, device = "png", view = c("height", "discharge"), output_dir = tempdir())
 
}
