% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_model.R
\name{load_model}
\alias{load_model}
\title{Load a model from basic files.}
\usage{
load_model(
  model_name,
  type,
  path = getOption("floodam_building_path"),
  file_name = getOption("floodam_building_file_name"),
  type_building = getOption("floodam_building_type_building"),
  version_building = NULL,
  inspect = TRUE,
  verbose = getOption("floodam_building_verbose")
)
}
\arguments{
\item{model_name}{character, name of the model}

\item{type}{character, type of the model}

\item{path}{list of useful paths, default to getOption("floodam_building_path")}

\item{file_name, }{list of useful file names, default to getOption("floodam_building_file_name")}

\item{type_building}{character, type of building file (building or yaml)}

\item{version_building}{character, version of building to be used}

\item{inspect}{boolean, shall information from building file be inspected according to pattern? Default to TRUE}

\item{verbose}{boolean, shall floodam tells what it is doing, default to getOption("floodam_building_verbose")}
}
\value{
An object of class "model" with those characteristics
\describe{
\item{name}{character, name of the model}
\item{type}{character, type of the model}
\item{path}{list, useful paths to read and write data}
\item{file_name}{list, useful file names to read and write data}
\item{building}{list, representation of data stored in the building file}
\item{furniture}{data frame of data in furniture.csv file}
}
}
\description{
Load a model from basic files.
}
\examples{

	model_path = list(
		data = system.file("extdata", package = "floodam.building"),
		output = tempdir()
	)
	load_model(model = "adu_t", type = "adu", path = model_path)

}
