% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_furniture.R
\name{load_furniture}
\alias{load_furniture}
\title{Load furniture for a given model.}
\usage{
load_furniture(model_name, path, file_name)
}
\arguments{
\item{model_name}{the name given to the model used to store log information}

\item{path}{list of useful paths}

\item{file_name}{list of useful file_names}
}
\value{
a data.frame of furniture present in the model. If the file furniture.csv does not yet exist, return NULL.
}
\description{
Load furniture for a given model.
}
\details{
Some tries are made on format:
\enumerate{
\item First, 'furniture.csv' is supposed to be readable by utils::read.csv2.
\item If not it is supposed to be readable by utils::read.csv.
\item If not, an error is returned. User is asked to manage format on his own.
}

Some tries are made on encoding:
\enumerate{
\item First, 'furniture.csv' is supposed to be encoded in UTF-8.
\item If this try makes some error, another try is made in ISO-8859-15.
\item If this second try does not work, an error is returned. User is asked to manage encoding on his own.
}
}
\examples{

	model = "adu_t"
	type = "adu"

	load_furniture(
		model_name = model, 
		path = update_path(
			model = model, 
			type = type, 
			path = list(
				data = system.file("extdata", package = "floodam.building"), 
				output = tempdir()
			)
		),
		file_name = init_file_name()
	)

}
