% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_limnigraph.R
\name{generate_limnigraph}
\alias{generate_limnigraph}
\title{Generate a limnigraph}
\usage{
generate_limnigraph(
  model,
  time,
  depth,
  exposition,
  verbose = getOption("floodam_building_verbose")
)
}
\arguments{
\item{model}{an object of class model}

\item{time}{numeric, time steps (in seconds) at which a specific floodwater
depth is reached}

\item{depth}{numeric, depths (in meters) reached at time steps given by
\code{time}. The vectors must be named after each \code{facade} exposed to the flood}

\item{exposition}{list, contains list of \code{facade} exposed to the flood event.
Each \code{facade} is a list of named vectors of the walls exposed in the same
way. Vectors are named after the \code{external} they belong to in the model.}

\item{verbose}{boolean, will floodam tells what it is doing, default to
getOption("floodam_building_verbose")}
}
\value{
a list containing the generated limnigraph and the corresponding
exposition data.
\itemize{
\item \code{limnigraph}: A matrix with time in the first column and floodwater depths
along the building walls in the subsequent columns.
\item \code{exposition}: A list of the matching wall exposures.
}
}
\description{
\code{generate_limnigraph()} builds external limnigraphs that are used as boundary
conditions for interior hydraulic simulation.
}
\details{
\strong{Data Structure:}
\itemize{
\item \code{time} provides the time steps at which the floodwater depth is defined.
This element sets the standard length for all limnigraph data.
\item \code{depth} Can be a numeric vector of the same length as \code{time}(for a single
limnigraph) or a matrix whose number of rows is equal to the length of \code{time}
(for multiple limnigraphs). Each column of the matrix represents a different
limnigraph, corresponding to a specific facade.
\item \code{exposition}: A list defining the walls exposed to the flood. Each element
of the list represents a facade, and contains a named list of walls
exposed to that facade.
}

\strong{Naming Conventions:}
\itemize{
\item When defining facades or external walls in your model, it's crucial to
include the keywords "facade" and "external" in their names (e.g.,
"facade_west", "external_groundfloor").
\item Ensure that the names used in the \code{exposition} list match the names of
the external walls in your model.
}

#' \strong{Error Handling:}
\itemize{
\item \strong{Incompatible lengths:} If \code{time} and \code{depth} have different lengths
(number of rows), the function will throw an error. Ensure that both vectors
have the same length.
\item \strong{Mismatched names:} If the column names in \code{depth} do not match the names
in \code{exposition}, the function will throw an error. Verify that the names are
consistent.
\item \strong{Incorrect wall names:} If the wall names in \code{exposition} do not exist in
your building model, the function may produce unexpected results.
Double-check the wall IDs.
}
}
\examples{

# Limnigraph
limnigraph = generate_limnigraph(
  model = adu_t,
  time = c(0, 300, 900),
  depth = cbind(facade_1 = c(0, 2, 0),
                facade_2 = c(0, 0, 0)),
  exposition = list(
    facade_1 = list(external = c("wall_A", "wall_B", "wall_C", "wall_D")),
   facade_2 = list(external = c("wall_E", "wall_F", "wall_G", "wall_H"))
  )
)

# Limnigraph simplified
limnigraph = generate_limnigraph(
	 model = adu_t,
  time = c(0, 300, 900),
  depth = cbind(facade_1 = c(0, 2, 0)),
  exposition = list(
    facade_1 = list(external =c("wall_A", "wall_B", "wall_C", "wall_D"))
  )
)

# declaring input and output paths

model_basement = analyse_model(
 model = adu_t_basement,
 stage = c("load", "extract", "damaging", "hydraulic")
)

# create limnigraph for multi level building
flood = generate_limnigraph(
 model = model_basement,
 time = c(0, 450, 900),
 depth = cbind(facade_1 = c(0, 0.2, 0),
   facade_2 = c(0, 0.5, 0)),
 exposition = list(
   facade_1 = list(
     external_groundfloor = c("wall_A"),
     external_basement = c("wall_A")
   ),
   facade_2 = list(
     external_groundfloor = c("wall_B", "wall_C"))
 )
)

}
