% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_building_information.R
\name{extract_building_information}
\alias{extract_building_information}
\title{Extract information of a model from building and furniture components}
\usage{
extract_building_information(
  model,
  verbose = getOption("floodam_building_verbose")
)
}
\arguments{
\item{model}{an object of class model}

\item{verbose}{logical, default to \code{getOption("floodam_building_verbose")}}
}
\value{
A list of data.frame giving a tabular view of elements present in
the object \code{model}.
}
\description{
\code{extract_building_information()} extracts all information at buiding levels
to update tabular views of what is present in the model.
}
\details{
Elements returned are:
\itemize{
\item \code{parameter}: list of data frames, giving information on some elementary
components used in the model
\item \code{storey}: data frame, information at storey level.
\item \code{room}: data frame, information at room level.
\item \code{wall}: data frame, information at wall level.
\item \code{opening}: data frame, information at opening level.
\item \code{coating}: data frame, information at coating level.
\item \code{furniture}: data.frame, information at furniture level. This data.frame
is taken from what already desbrided in model, and adjusted  according
to information in building.
}
}
\examples{

data_table = extract_building_information(adu_t)

}
