% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elementary_adaptation_cost.R
\name{elementary_adaptation_cost}
\alias{elementary_adaptation_cost}
\title{Add the detail and costs of each new material measure}
\usage{
elementary_adaptation_cost(
  measure_cost,
  material_costs,
  reference,
  component,
  replacement,
  what,
  elementary,
  sub_type = NULL,
  coating = NULL,
  insulating = NULL,
  render = NULL
)
}
\arguments{
\item{measure_cost}{list of the different cost to be updated with the replacement measure}

\item{material_costs}{additional data-frame filling cost gaps in floodam.building::COMPONENT_ELEMENTARY}

\item{reference}{the model without measure}

\item{component}{the model with adaptation measures}

\item{replacement}{the list from l_part with the details of one material modification}

\item{what}{the column of the two models to compare (column changed by the measures)}

\item{elementary}{the column of the two models containing the elementary components}

\item{sub_type}{second column of the model, needed to select a certain object (ex: window, door...)}

\item{coating}{Null or column of coating material, if an element (floor, wall...) has a coating, add the price of the coating}

\item{insulating}{Null or column of insulating material, if an element (floor, wall...) has an insulating, add the price of the insulating}

\item{render}{Null or column of render material, if an element (floor, wall...) has a render, add the price of the render}
}
\value{
measure_cost, a list with the cost of prevention (only material modification) and repair (repair due to flood and modification of material at the same time) and the details
}
\description{
Add the detail and costs of each new material measure
}
\keyword{internal}
