% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_exchange.R
\name{compute_exchange}
\alias{compute_exchange}
\title{Compute surface and flow for a matrix of openings}
\usage{
compute_exchange(exchange)
}
\arguments{
\item{exchange}{matrix, containing informations for openings. See details.}
}
\value{
matrix of surface and flow for each openings.
}
\description{
Compute surface and flow for a matrix of openings
}
\details{
\code{compute_exchange()} computes wet surfaces and flows for a matrix of openings.

The matrix must be organized as follows:
\itemize{
\item columns give informations for openings (pssibly named, butnot mandatory)
\item rows give informations for each of those entities (names are mandatory):
\itemize{
\item \code{width}: width of the opening in meter
\item \code{z_bottom}: absolute altitude of the bottom of the opening in meter
\item \code{z_top}: absolute altitude of the top of the opening in meter
\item \code{Cd}: coefficient giving the loss of charge (no dimension)
\item \code{z_up}: absolute level of water in the 'upward' side of the opening in meter
\item \code{z_down}: absolute level of water in the 'downward' side of the opening in meter
}
}

\code{compute_exchange()} is the R counterpart of \code{rcpp_compute_exchange()}. Both functions should give
exactly the same numeric results.  \code{compute_exchange()} is used mainly for testing purposes.
}
