% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyse_model.R
\name{analyse_model}
\alias{analyse_model}
\title{Analyse a model}
\usage{
analyse_model(
  model,
  type = "",
  stage = "",
  hazard_range = getOption("floodam_building_hazard_range"),
  path = getOption("floodam_building_path"),
  file_name = getOption("floodam_building_file_name"),
  type_building = getOption("floodam_building_type_building"),
  version_building = NULL,
  verbose = getOption("floodam_building_verbose")
)
}
\arguments{
\item{model}{either a character, name given to the model or an object of
class model}

\item{type}{character, type of model that is loaded, default to ""}

\item{stage}{character, stage of the analysis to execute, default to
nothing; admitted values: "load", "extract", "damaging", "hydraulic",
"graph", "save", and "display".  If "all" is specified, all available stages
will be  executed. See details}

\item{hazard_range}{if damaging are calculated, gives the range for hazard,
default to getOption("floodam_building_hazard_range")}

\item{path}{list of useful paths, default to
getOption("floodam_building_path")}

\item{file_name, }{list of useful file names, default to
getOption("floodam_building_file_name")}

\item{type_building}{character, type of building file (building or yaml)}

\item{version_building}{character, version of building model to be used}

\item{verbose}{boolean, will floodam tells what it is doing, default to
getOption("floodam_building_verbose")}
}
\value{
an object of class model. See details
}
\description{
This function performs a comprehensive analysis of a building model,
allowing users to selectively execute different stages of the analysis
pipeline, including loading the model, extracting information, calculating
damages, generating hydraulic inputs, plotting results, and saving the model.
}
\details{
The \code{stage} parameter is a crucial parameter for controlling exactly which
parts of the analysis pipeline are executed. It is a character vector that
specifies the sequence of analysis steps (or "stages") to run:
\itemize{
\item "load" loads input file and creates object of class model. This is the
first stage to run
\item "extract" extracts information from the model and organizes it in tables.
This is the second stage you need to run and requires the "load" stage
to have been run first
\item "damaging" computes the damage function of the model. Requires the
"extract" stage
\item "hydraulic" extracts hydraulic input data from model and computes damage
functions by room and segment of external wall (input in function
\code{analyse_hydraulics()}). Requires the "extract" stage
\item "graph" saves plots in a temporary directory. The number of plots created
depends on the stage: Top and side view of building modeled and, if
"damaging" stage has been called already, the damaging function.
Requires the "extract" stage
\item "save" saves data in the path stored in the model object created by the
function. Requires the "extract" stage
\item "display" displays plot of top view of the building model. Requires the
"extract" stage
\item "all" executes stages "load", "extract", "damaging", "hydraulic", "graph",
"save" and "display"
}

The function returns a model object, which is a list with the following
elements (the presence of each element depends on the stages executed):
\itemize{
\item "name": a character string representing the model name
\item "category": a character string representing the damage category
\item "path": a list containing file paths related to the model
\item "file_name": a list containing the file names related to the model
\item "data_table": a list of data.frames containing information about the
building components and their attributes. Created/updated by the "extract"
stage
\item "value": a list of data.frames with information about (i) the monetary
value of the building and its contents and (ii) the internal and external
surfaces calculated with the input data. Created by the "extract" stage
\item "damaging": a list containing damage calculations. Created by the
"damaging" stage
\item "hydraulic": a list containing input data for a hydraulic model. Created by
the "hydraulic" stage
\item "dam_room_wall": a list containing damage calculations by room and wall
segment. Created by the "hydraulic" stage.
}
}
\examples{

# Example 1
# declaring input and output paths
model_path = list(
	data = system.file("extdata", package = "floodam.building"),
	output = tempdir()
)

# analyzing model 'adu_t' of type 'adu' using stages *load*, *extract* and 
# *damaging* 
analyse_model(
	model = "adu_t", 
	type = "adu", 
	stage = c("load", "extract", "damaging"), 
	path = model_path
)

# Example 2
# using preloaded model 'adu_t_basement' 
model = adu_t_basement

# extracting model data
model = analyse_model(model = model, stage = "extract")

# calculating damage function
model = analyse_model(model = model, stage = "damaging")

# calculating hydraulic inputs
model = analyse_model(model = model, stage = "hydraulic")

}
