% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyse_hydraulic.R
\name{analyse_hydraulic}
\alias{analyse_hydraulic}
\title{Perfom hydraulic analysis for a model}
\usage{
analyse_hydraulic(
  model,
  limnigraph,
  flood_duration,
  opening_scenario = c("combine", "close", "open"),
  dt_max = 0.5,
  Cd = 0.42,
  clearance = getOption("floodam_building_hydraulic_close_opening_clearance"),
  height_break = 1,
  sim_id = NULL,
  stage = "",
  what = c("hmax", "damage"),
  detail = TRUE,
  verbose = getOption("floodam_building_verbose"),
  threshold_height = 1,
  threshold_duration = 12
)
}
\arguments{
\item{model}{an object of class model}

\item{limnigraph}{numeric, matrix of floodwater depth heights by instant t
for each exterior opening exposed to flooding}

\item{flood_duration}{numeric, duration of the flood event in seconds,
optional; if not provided, calculated using limnigraph}

\item{opening_scenario}{character, one of the following options: "open",
"close", "combine". See details.}

\item{dt_max}{numeric, optional; maxmimum timestep for simulation}

\item{Cd}{numeric, optional; discharge coefficient for each opening,
default to getOption("floodam_building_hydraulic_discharge_coefficient")}

\item{clearance}{numeric, distance between the opening and its
frame in centimeters. It represents water tightness for
the opening. It is a named vector of length 2, containing clearances for
\code{under} and the \code{side} of the opening.
Default to c(under = 0.5, side = 0.5)}

\item{height_break}{numeric, the differential height on each side of an
opening needed to break it}

\item{sim_id}{character, optional; id of simulation}

\item{stage}{character, what are the stages that should be done, default to
nothing, can be "hydraulic", "damaging", "dangerosity", "graph", "save",
"display"}

\item{what}{character, outputs to be saved in a temporary directory. Only
works along with stage \code{save}. If detail is FALSE only "hmax" and
"damage" can be saved}

\item{detail}{boolean, if FALSE only returns hmax and damage, else returns
all the outputs}

\item{verbose}{boolean, will floodam tells what it is doing, default to
getOption("floodam_building_verbose")}

\item{threshold_height}{numeric, height in centimeters above which a damage
is considered}

\item{threshold_duration}{numeric, maximum duration for the damage function
used for interpolation. See in documentation of \code{get_hydraulic_damage()}.}
}
\value{
list of matrix:
\itemize{
\item \code{h}: water depths in each rooms for each time step
\item \code{eQ}: water exchanges through openings for each time step
\item \code{v}: velocity of exchanges through openings for each time step
\item \code{eS}: wet surface of exchanges through openings for each time step
\item \code{hmax} : peak water depths in each rooms and their peak time
\item \code{dangerosity} (optional) : dangerosity when opening a door
\item \code{damage} (optional) : damage per room based on peak water depth
}
}
\description{
\code{analyse_hydraulic()} perfoms hydraulic analysis for a model.
}
\details{
\code{stage} pilots what the function is doing:
\itemize{
\item "hydraulic" mandatory if you want something to be done, computes hydraulics
for the model
\item "damaging" analyse damaging according to the hydraulics
\item "dangerosity" analyse dangerosity according to the hydraulics
\item "graph" saves visuals in a temporary directory
\item "save" saves data written en parameter \code{what} in a temporary directory
\item "display" displays water level if paramater \code{detail} is TRUE
}

\code{opening_scenario} controls the state of openings:
\itemize{
\item "open": scenario where all openings are open
\item "close": scenario where all openings are closed
\item "combine": scenario where all exterior openings are closed and all interior
openings are open
}

If \code{flood_duration} is missing, it is computed from \code{limnigraph} (max time +
half an hour).
}
\examples{

model = adu_t

# generate limnigraph
flood = generate_limnigraph(
	 model = model,
  time = c(0, 300, 900),
  depth = cbind(facade_1 = c(0, 3, 0)),
  exposition = list(
    facade_1 = list(external = c("wall_A", "wall_B", "wall_C", "wall_D", "wall_E",
		"wall_F", "wall_G", "wall_H")))
)

hydraulic = analyse_hydraulic(
	model = model,
	limnigraph = flood,
	sim_id = "test",
	stage = "hydraulic"
)

}
