% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust_h_abs.R
\name{adjust_h_abs}
\alias{adjust_h_abs}
\title{Adjust absolute H of components}
\usage{
adjust_h_abs(data_table, h_abs = c("model", "room", "component"), h_ref = 0)
}
\arguments{
\item{data_table}{list of data.frame describing components in a model.}

\item{h_abs}{character defining how the adjustment is done.}

\item{h_ref}{numeric, of length 1, that gives the H reference in the model.}
}
\value{
The same list of data.frame, each with fields \code{H} and \code{H_abs} that
has been
adjusted (or maybe created).
}
\description{
\code{adjust_h_abs()} adjusts the filed \code{H_abs} in all data.frame of \code{data_table}.
}
\details{
If some of the data.frame in data_table do not have a field \code{H}, it is added
and set to 0. Il some values in any field \code{H} are missing (NA values), they
are set to 0.

\code{H_abs} is adjusted depending on the value of \code{h_abs}:
\itemize{
\item For \strong{model}, all \code{H_abs} are adjusted by taking into account the relative
height \code{H} of the component and the absolute height \code{H_abs} of its container.
\item For \strong{room}, all rooms are supposed to be at \code{H_abs = 0}, then the same
logic as in case \strong{model} is applied. Relative \code{H} for storeys and rooms
are set to 0 for consistency.
\item For \strong{component} all relative height \code{H} and absolute height \code{H_abs} are
set to 0.
}

\strong{Note} :
\itemize{
\item one room is "contained" in one storey
\item one wall or one furniture is "contained" in one room
\item one opening or one coating is "contained" in one wall
}
}
\keyword{internal}
