% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust_elementary_damaging.R
\name{adjust_elementary_damaging}
\alias{adjust_elementary_damaging}
\title{Adjust elementary damaging function to local characteristics}
\usage{
adjust_elementary_damaging(
  component,
  what = NULL,
  damaging = NULL,
  dilapidation = 0,
  surface_height = NULL,
  hazard_range = NULL,
  synthetic = TRUE,
  graph = FALSE,
  talkative = getOption("floodam_building_talkative"),
  file_log
)
}
\arguments{
\item{component}{data.frame with one row, useful information (H_abs, dilapidation, quantity, height)}

\item{what}{character, what should be used in component}

\item{damaging, }{array of class elementary_damaging}

\item{dilapidation, }{numeric, dilapidation rate to be applied, default to 0}

\item{surface_height}{function, how to calculate surface depending on H_abs, only valid for elementary components linked to wall, default to NULL}

\item{hazard_range}{list, desired hazard_range, default to getOption("floodam_building_hazard_range")}

\item{synthetic, }{boolean, should result be synthetic}

\item{graph, }{boolean, should result be plotted}

\item{talkative, }{boolean, should the function be talkative (for debug purpose)}

\item{file_log, }{character, path of the file where to write some possible problems}
}
\value{
an array of two dimensions with same h_range and d_range than damaging
}
\description{
Adjust elementary damaging function to local characteristics
}
\keyword{internal}
