% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ACTIVITY}
\alias{ACTIVITY}
\title{Information on activity.}
\format{
A list of data.frame:
\strong{category}: data.frame giving the correspondence between models and
category of activities
\itemize{
\item \strong{model_name} character, name of the model
\item \strong{category} character, name of the category of activity
\item \strong{category_label_fr} character, label in French
\item \strong{APE_05} character, APE code at level 5 of the model
\item \strong{APE_05_label_fr} character, label in French of the APE code
\item \strong{n_employee} double, number of employee attached to the given model
}

\strong{typology}: data.frame giving the correspondence between category of
activities and APE codes at level 5
\itemize{
\item \strong{APE_05} character, APE code at level 5
\item \strong{type} character, type of stake, only those of type activity are used
for extrapolation
\item \strong{category} character, name of the category of activity attached to
the APE code
\item \strong{category_label_fr} character, label in French
\item \strong{APE_05_label_fr} character, label in French of the APE code
}

\strong{esane}: data.frame giving the correspondence between category of
activities and APE codes at level 5, with information coming frome esane
data base (INSEE)
\itemize{
\item \strong{APE_05} character, APE code at level 5
\item \strong{type} character, type of stake, only those of type activity are used
for extrapolation
\item \strong{category} character, name of the category of activity attached to
the APE code
\item \strong{category_label_fr} character, label in French
\item \strong{APE_05_label_fr} character, label in French of the APE code
\item \strong{n} double, number of enterprises for all the activities in France of
the given APE code
\item \strong{employee} double, number of employee for all the activities in
France of the given APE code
\item \strong{equipment} double, value of equipment for all the activities in
France of the given APE code
\item \strong{stock} double, value of stock for all the activities in France of
the given APE code
\item \strong{level} factor, level at which data could be extracted from esane
data base (N1, N2, N3 or N5) or "no data" when nothing was available
\item \strong{ACTENTNOMESS} double, value of field ACTENTNOMESS, number of
enterprises for all the activities in France of the given APE code
\item \strong{EMPSALNOMESS} double, value of field EMPSALNOMESS, number of
employees for all the activities in France of the given APE code
\item \strong{BAC123VALESE} double, value of field BAC123VALESE, value of specific
equipment for all the activities in France of the given APE code
\item \strong{BAC124VALESE} double, value of field BAC124VALESE, value of non
specific equipment  for all the activities in France of the given
APE code
\item \strong{BAC152VALESE} double, value of field BAC152VALESE, value of stock
(input) for all the activities in France of the given APE code
\item \strong{BAC155VALESE} double, value of field BAC155VALESE, value of stock
(intermediate) for all the activities in France of the given APE code
\item \strong{BAC156VALESE} double, value of field BAC156VALESE, value of stock
(output) for all the activities in France of the given APE code
}
}
\usage{
ACTIVITY
}
\description{
List of data.frame giving complementary information on activities.
}
\keyword{datasets}
