# This version is compatible with version 2 of models
#
# Changes from version 1
#	- coating elements in wall (building part) are defined by type and no more by material

XML = list(
	version_03 = list(
		general = list(
			STATUS = "MANDATORY",
			VALUE = "list",
			type = list(
				STATUS = "MANDATORY",
				VALUE = "character"),	
			dilapidation = list(
				STATUS = "MANDATORY",
				VALUE = "double"),
			version = list(
				STATUS = "MANDATORY",
				VALUE = "character")),
					
		element = list(
			STATUS = "MANDATORY",
			VALUE = "list",
			
			baseboard = list(
				STATUS = "OPTIONAL",
				VALUE = "list",
				baseboard = list(
					STATUS = "MANDATORY",
					SEVERAL = TRUE,
					VALUE = "list",
					material = list(
						STATUS = "MANDATORY",
						VALUE = "character"),
					width = list(
						STATUS = "MANDATORY",
						VALUE = "double"))),
						
			ceiling = list(
				STATUS = "MANDATORY",
				VALUE = "list",
				ceiling = list(
					STATUS = "MANDATORY",
					SEVERAL = TRUE,
					VALUE = "list",
					material = list(
						STATUS = "MANDATORY",
						VALUE = "character"),
					insulating = list(
						STATUS = "OPTIONAL",
						VALUE = "character"),
					coating = list(
						STATUS = "OPTIONAL",
						VALUE = "character"),
					H = list(
						STATUS = "MANDATORY",
						VALUE = "double"))),

			coating = list(
				STATUS = "OPTIONAL",
				VALUE = "list",
				coating = list(
					STATUS = "MANDATORY",
					SEVERAL = TRUE,
					VALUE = "list",
					material = list(
						STATUS = "MANDATORY",
						VALUE = "character"))),

			coverstrip = list(
				STATUS = "OPTIONAL",
				VALUE = "list",
				coverstrip = list(
					STATUS = "MANDATORY",
					SEVERAL = TRUE,
					VALUE = "list",
					material = list(
						STATUS = "MANDATORY",
						VALUE = "character"))),

			floor = list(
				STATUS = "OPTIONAL",
				VALUE = "list",
				floor = list(
					STATUS = "MANDATORY",
					SEVERAL = TRUE,
					VALUE = "list",
					material = list(
						STATUS = "MANDATORY",
						VALUE = "character"),
					insulating = list(
						STATUS = "OPTIONAL",
						VALUE = "character"),
					coating = list(
						STATUS = "OPTIONAL",
						VALUE = "character"))),

			opening = list(
				STATUS = "OPTIONAL",
				VALUE = "list",
				generic = list(
					STATUS = "MANDATORY",
					SEVERAL = TRUE,
					VALUE = "list",
					MANDATORY = c("door"),
					OPTIONAL = c("french_window", "window"),
					opening_type = list(
						STATUS = "MANDATORY",
						VALUE = "character"),
					material = list(
						STATUS = "OPTIONAL",
						VALUE = "character"),
					shutter = list(
						STATUS = "OPTIONAL",
						VALUE = "character"),
					height = list(
						STATUS = "MANDATORY",
						VALUE = "double"),
					width = list(
						STATUS = "MANDATORY",
						VALUE = "double"))),

			wall = list(
				STATUS = "MANDATORY",
				VALUE = "list",
				generic = list(
					STATUS = "MANDATORY",
					SEVERAL = TRUE,
					VALUE = "list",
					MANDATORY = c("load_bearing_wall"),
					OPTIONAL = c("lining", "partition", "empty"),
					wall_type = list(
						STATUS = "MANDATORY",
						VALUE = "character"),				
					material = list(
						STATUS = "MANDATORY",
						VALUE = "character"),
					render = list(
						STATUS = "OPTIONAL",
						VALUE = "character"),
					insulating = list(
						STATUS = "OPTIONAL",
						VALUE = "character")))
		),

		exterior = list(
			STATUS = "OPTIONAL",
			VALUE = "list",

			protection = list(
				STATUS = "OPTIONAL",
				VALUE = "list",
				type = list(
					STATUS = "MANDATORY",
					VALUE = "character"),	
				elevation = list(
					STATUS = "MANDATORY",
					VALUE = "double"),
				duration = list(
					STATUS = "MANDATORY",
					VALUE = "double"),
				reliability = list(
					STATUS = "MANDATORY",
					VALUE = "double")),

				generic = list(
					STATUS = "MANDATORY",
					VALUE = "list",
					SEVERAL = TRUE,
					MANDATORY = c("limit"),
					OPTIONAL = c("part"),
					name = list(
						STATUS = "OPTIONAL",
						VALUE = "character"),
					floor = list(
						STATUS = "OPTIONAL",
						VALUE = "character"),
					H = list(
						STATUS = "OPTIONAL",
						VALUE = "double"),
					wall = list(
						STATUS = "MANDATORY",
						SEVERAL = TRUE,
						VALUE = "list",
						coordinates = list(
							STATUS = "MANDATORY",
							VALUE = "double"),
						type = list(
							STATUS = "MANDATORY",
							VALUE = "character"),
						H = list(
							STATUS = "OPTIONAL",
							VALUE = "double"),
						height = list(
							STATUS = "OPTIONAL",
							VALUE = "double"),
						coating = list(
							STATUS = "OPTIONAL",
							SEVERAL = TRUE,
							VALUE = "list",
							type = list(
								STATUS = "MANDATORY",
								VALUE = "character"),
							H = list(
								STATUS = "OPTIONAL",
								VALUE = "double")),
						opening = list(
							STATUS = "OPTIONAL",
							SEVERAL = TRUE,
							VALUE = "list",
							type = list(
								STATUS = "MANDATORY",
								VALUE = "character"),
							coverstrip = list(
								STATUS = "OPTIONAL",
								VALUE = "character"),
							coordinates = list(
								STATUS = "OPTIONAL",
								VALUE = "double"),
							H = list(
								STATUS = "MANDATORY",
								VALUE = "double"))))
		),
			
		building = list(
			STATUS = "MANDATORY",
			SEVERAL = TRUE,
			VALUE = "list",
			
			name = list(
				STATUS = "OPTIONAL",
				VALUE = "character"),
			H = list(
				STATUS = "MANDATORY",
				VALUE = "double"),
			height = list(
				STATUS = "MANDATORY",
				VALUE = "double"),
			protection = list(
				STATUS = "OPTIONAL",
				VALUE = "list",
				type = list(
					STATUS = "MANDATORY",
					VALUE = "character"),	
				elevation = list(
					STATUS = "MANDATORY",
					VALUE = "double"),
				duration = list(
					STATUS = "MANDATORY",
					VALUE = "double"),
				reliability = list(
					STATUS = "MANDATORY",
					VALUE = "double")),
				
			storey = list(
				STATUS = "MANDATORY",
				SEVERAL = TRUE,
				VALUE = "list",
				name = list(
					STATUS = "OPTIONAL",
					VALUE = "character"),
				H = list(
					STATUS = "MANDATORY",
					VALUE = "double"),
				height = list(
					STATUS = "OPTIONAL",
					VALUE = "double"),
									
				generic = list(
					STATUS = "MANDATORY",
					SEVERAL = TRUE,
					VALUE = "list",
					MANDATORY = c("external", "room"),
					name = list(
						STATUS = "OPTIONAL",
						VALUE = "character"),
					baseboard = list(
						STATUS = "OPTIONAL",
						VALUE = "character"),
					ceiling = list(
						STATUS = "OPTIONAL",
						VALUE = "character"),
					floor = list(
						STATUS = "OPTIONAL",
						VALUE = "character"),
					H = list(
						STATUS = "OPTIONAL",
						VALUE = "double"),
					wall = list(
						STATUS = "MANDATORY",
						SEVERAL = TRUE,
						VALUE = "list",
						coordinates = list(
							STATUS = "MANDATORY",
							VALUE = "double"),
						name = list(
							STATUS = "OPTIONAL",
							VALUE = "character"),
						type = list(
							STATUS = "MANDATORY",
							VALUE = "character"),
						H = list(
							STATUS = "OPTIONAL",
							VALUE = "double"),
						height = list(
							STATUS = "OPTIONAL",
							VALUE = "double"),
						coating = list(
							STATUS = "OPTIONAL",
							SEVERAL = TRUE,
							VALUE = "list",
							type = list(
								STATUS = "MANDATORY",
								VALUE = "character"),
							H = list(
								STATUS = "OPTIONAL",
								VALUE = "double")),
						opening = list(
							STATUS = "OPTIONAL",
							SEVERAL = TRUE,
							VALUE = "list",
                            name = list(
                                STATUS = "OPTIONAL",
                                VALUE = "character"),
							type = list(
								STATUS = "MANDATORY",
								VALUE = "character"),
							coverstrip = list(
								STATUS = "OPTIONAL",
								VALUE = "character"),
							coordinates = list(
								STATUS = "OPTIONAL",
								VALUE = "double"),
							H = list(
								STATUS = "MANDATORY",
								VALUE = "double"))))))
	),

	version_02 = list(
		general = list(
			STATUS = "MANDATORY",
			VALUE = "list",
			type = list(
				STATUS = "MANDATORY",
				VALUE = "character"),	
			H = list(
				STATUS = "MANDATORY",
				VALUE = "double"),
			height = list(
				STATUS = "MANDATORY",
				VALUE = "double"),
			dilapidation = list(
				STATUS = "MANDATORY",
				VALUE = "double"),
			version = list(
				STATUS = "MANDATORY",
				VALUE = "character")),
					
		element = list(
			STATUS = "MANDATORY",
			VALUE = "list",
			
			baseboard = list(
				STATUS = "OPTIONAL",
				VALUE = "list",
				baseboard = list(
					STATUS = "MANDATORY",
					SEVERAL = TRUE,
					VALUE = "list",
					material = list(
						STATUS = "MANDATORY",
						VALUE = "character"),
					width = list(
						STATUS = "MANDATORY",
						VALUE = "double"))),
						
			ceiling = list(
				STATUS = "MANDATORY",
				VALUE = "list",
				ceiling = list(
					STATUS = "MANDATORY",
					SEVERAL = TRUE,
					VALUE = "list",
					material = list(
						STATUS = "MANDATORY",
						VALUE = "character"),
					insulating = list(
						STATUS = "OPTIONAL",
						VALUE = "character"),
					coating = list(
						STATUS = "OPTIONAL",
						VALUE = "character"),
					H = list(
						STATUS = "MANDATORY",
						VALUE = "double"))),

			coating = list(
				STATUS = "OPTIONAL",
				VALUE = "list",
				coating = list(
					STATUS = "MANDATORY",
					SEVERAL = TRUE,
					VALUE = "list",
					material = list(
						STATUS = "MANDATORY",
						VALUE = "character"))),

			coverstrip = list(
				STATUS = "OPTIONAL",
				VALUE = "list",
				coverstrip = list(
					STATUS = "MANDATORY",
					SEVERAL = TRUE,
					VALUE = "list",
					material = list(
						STATUS = "MANDATORY",
						VALUE = "character"))),

			floor = list(
				STATUS = "OPTIONAL",
				VALUE = "list",
				floor = list(
					STATUS = "MANDATORY",
					SEVERAL = TRUE,
					VALUE = "list",
					material = list(
						STATUS = "MANDATORY",
						VALUE = "character"),
					insulating = list(
						STATUS = "OPTIONAL",
						VALUE = "character"),
					coating = list(
						STATUS = "OPTIONAL",
						VALUE = "character"))),

			opening = list(
				STATUS = "OPTIONAL",
				VALUE = "list",
				generic = list(
					STATUS = "MANDATORY",
					SEVERAL = TRUE,
					VALUE = "list",
					MANDATORY = c("door"),
					OPTIONAL = c("french_window", "window"),
					opening_type = list(
						STATUS = "MANDATORY",
						VALUE = "character"),
					material = list(
						STATUS = "OPTIONAL",
						VALUE = "character"),
					shutter = list(
						STATUS = "OPTIONAL",
						VALUE = "character"),
					height = list(
						STATUS = "MANDATORY",
						VALUE = "double"),
					width = list(
						STATUS = "MANDATORY",
						VALUE = "double"))),

			wall = list(
				STATUS = "MANDATORY",
				VALUE = "list",
				generic = list(
					STATUS = "MANDATORY",
					SEVERAL = TRUE,
					VALUE = "list",
					MANDATORY = c("load_bearing_wall"),
					OPTIONAL = c("lining", "partition", "empty"),
					wall_type = list(
						STATUS = "MANDATORY",
						VALUE = "character"),				
					material = list(
						STATUS = "MANDATORY",
						VALUE = "character"),
					render = list(
						STATUS = "OPTIONAL",
						VALUE = "character"),
					insulating = list(
						STATUS = "OPTIONAL",
						VALUE = "character")))
		),

		building = list(
			STATUS = "MANDATORY",
			VALUE = "list",
			
			storey = list(
				STATUS = "MANDATORY",
				SEVERAL = TRUE,
				VALUE = "list",
				name = list(
					STATUS = "OPTIONAL",
					VALUE = "character"),
				H = list(
					STATUS = "MANDATORY",
					VALUE = "double"),
				height = list(
					STATUS = "OPTIONAL",
					VALUE = "double"),
									
				generic = list(
					STATUS = "MANDATORY",
					SEVERAL = TRUE,
					VALUE = "list",
					MANDATORY = c("external", "room"),
					name = list(
						STATUS = "OPTIONAL",
						VALUE = "character"),
					baseboard = list(
						STATUS = "OPTIONAL",
						VALUE = "character"),
					ceiling = list(
						STATUS = "OPTIONAL",
						VALUE = "character"),
					floor = list(
						STATUS = "OPTIONAL",
						VALUE = "character"),
					H = list(
						STATUS = "OPTIONAL",
						VALUE = "double"),
					wall = list(
						STATUS = "MANDATORY",
						SEVERAL = TRUE,
						VALUE = "list",
						coordinates = list(
							STATUS = "MANDATORY",
							VALUE = "double"),
						name = list(
                                STATUS = "OPTIONAL",
                                VALUE = "character"),
						type = list(
							STATUS = "MANDATORY",
							VALUE = "character"),
						H = list(
							STATUS = "OPTIONAL",
							VALUE = "double"),
						height = list(
							STATUS = "OPTIONAL",
							VALUE = "double"),
						coating = list(
							STATUS = "OPTIONAL",
							SEVERAL = TRUE,
							VALUE = "list",
							type = list(
								STATUS = "MANDATORY",
								VALUE = "character"),
							H = list(
								STATUS = "OPTIONAL",
								VALUE = "double")),
						opening = list(
							STATUS = "OPTIONAL",
							SEVERAL = TRUE,
							VALUE = "list",
                            name = list(
                                STATUS = "OPTIONAL",
                                VALUE = "character"),
							type = list(
								STATUS = "MANDATORY",
								VALUE = "character"),
							coverstrip = list(
								STATUS = "OPTIONAL",
								VALUE = "character"),
							coordinates = list(
								STATUS = "OPTIONAL",
								VALUE = "double"),
							H = list(
								STATUS = "MANDATORY",
								VALUE = "double"))))))
	),
	
	version_01 = list(
		general = list(
			STATUS = "MANDATORY",
			VALUE = "list",
			type = list(
				STATUS = "OPTIONAL",
				VALUE = "character"),	
			H = list(
				STATUS = "MANDATORY",
				VALUE = "double"),
			height = list(
				STATUS = "MANDATORY",
				VALUE = "double"),
			dilapidation = list(
				STATUS = "MANDATORY",
				VALUE = "double"),
			version = list(
				STATUS = "OPTIONAL",
				VALUE = "character")),
					
		element = list(
			STATUS = "MANDATORY",
			VALUE = "list",
			
			baseboard = list(
				STATUS = "OPTIONAL",
				VALUE = "list",
				baseboard = list(
					STATUS = "MANDATORY",
					SEVERAL = TRUE,
					VALUE = "list",
					material = list(
						STATUS = "MANDATORY",
						VALUE = "character"),
					width = list(
						STATUS = "MANDATORY",
						VALUE = "double"))),
						
			ceiling = list(
				STATUS = "MANDATORY",
				VALUE = "list",
				ceiling = list(
					STATUS = "MANDATORY",
					SEVERAL = TRUE,
					VALUE = "list",
					material = list(
						STATUS = "MANDATORY",
						VALUE = "character"),
					insulating = list(
						STATUS = "OPTIONAL",
						VALUE = "character"),
					coating = list(
						STATUS = "OPTIONAL",
						VALUE = "character"),
					H = list(
						STATUS = "MANDATORY",
						VALUE = "double"))),

			coating = list(
				STATUS = "OPTIONAL",
				VALUE = "list",
				coating = list(
					STATUS = "MANDATORY",
					SEVERAL = TRUE,
					VALUE = "list",
					material = list(
						STATUS = "MANDATORY",
						VALUE = "character"))),

			coverstrip = list(
				STATUS = "OPTIONAL",
				VALUE = "list",
				coverstrip = list(
					STATUS = "MANDATORY",
					SEVERAL = TRUE,
					VALUE = "list",
					material = list(
						STATUS = "MANDATORY",
						VALUE = "character"))),

			opening = list(
				STATUS = "OPTIONAL",
				VALUE = "list",
				generic = list(
					STATUS = "MANDATORY",
					SEVERAL = TRUE,
					VALUE = "list",
					MANDATORY = c("door"),
					OPTIONAL = c("french_window", "window"),
					opening_type = list(
						STATUS = "MANDATORY",
						VALUE = "character"),
					material = list(
						STATUS = "OPTIONAL",
						VALUE = "character"),
					location = list(
						STATUS = "OPTIONAL",
						VALUE = "character"),
					shutter = list(
						STATUS = "OPTIONAL",
						VALUE = "character"),
					height = list(
						STATUS = "MANDATORY",
						VALUE = "double"),
					width = list(
						STATUS = "MANDATORY",
						VALUE = "double"))),

			wall = list(
				STATUS = "MANDATORY",
				VALUE = "list",
				generic = list(
					STATUS = "MANDATORY",
					SEVERAL = TRUE,
					VALUE = "list",
					MANDATORY = c("load_bearing_wall"),
					OPTIONAL = c("lining", "partition", "empty"),
					wall_type = list(
						STATUS = "MANDATORY",
						VALUE = "character"),				
					material = list(
						STATUS = "MANDATORY",
						VALUE = "character"),
					render = list(
						STATUS = "OPTIONAL",
						VALUE = "character"),
					insulating = list(
						STATUS = "OPTIONAL",
						VALUE = "character")))
		),

		building = list(
			STATUS = "MANDATORY",
			VALUE = "list",
			
			storey = list(
				STATUS = "MANDATORY",
				SEVERAL = TRUE,
				VALUE = "list",
				name = list(
					STATUS = "OPTIONAL",
					VALUE = "character"),
				H = list(
					STATUS = "MANDATORY",
					VALUE = "double"),
				height = list(
					STATUS = "OPTIONAL",
					VALUE = "double"),
									
				generic = list(
					STATUS = "MANDATORY",
					SEVERAL = TRUE,
					VALUE = "list",
					MANDATORY = c("external", "room"),
					name = list(
						STATUS = "OPTIONAL",
						VALUE = "character"),
					baseboard = list(
						STATUS = "OPTIONAL",
						VALUE = "character"),
					ceiling = list(
						STATUS = "OPTIONAL",
						VALUE = "character"),
					floor = list(
						STATUS = "OPTIONAL",
						VALUE = "character"),
					H = list(
						STATUS = "OPTIONAL",
						VALUE = "double"),
					wall = list(
						STATUS = "MANDATORY",
						SEVERAL = TRUE,
						VALUE = "list",
						coordinates = list(
							STATUS = "MANDATORY",
							VALUE = "double"),
						type = list(
							STATUS = "MANDATORY",
							VALUE = "character"),
						H = list(
							STATUS = "OPTIONAL",
							VALUE = "double"),
						height = list(
							STATUS = "OPTIONAL",
							VALUE = "double"),
						coating = list(
							STATUS = "OPTIONAL",
							SEVERAL = TRUE,
							VALUE = "list",
							material = list(
								STATUS = "MANDATORY",
								VALUE = "character"),
							H = list(
								STATUS = "OPTIONAL",
								VALUE = "double")),
						opening = list(
							STATUS = "OPTIONAL",
							SEVERAL = TRUE,
							VALUE = "list",
                            name = list(
                                STATUS = "OPTIONAL",
                                VALUE = "character"),
							type = list(
								STATUS = "MANDATORY",
								VALUE = "character"),
							coverstrip = list(
								STATUS = "OPTIONAL",
								VALUE = "character"),
							coordinates = list(
								STATUS = "OPTIONAL",
								VALUE = "double"),
							H = list(
								STATUS = "MANDATORY",
								VALUE = "double"))))))
	)
)
