## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk[["set"]](
  collapse = TRUE,
  comment = "#>",
  fig.align = "center"
)


## ----setup--------------------------------------------------------------------
#> Loading required package: floodam.building
library(floodam.building)

#> set up model to use example shipped with floodam
model_path = list(
  data = system.file("extdata", package = "floodam.building"),
  output = tempdir()
)


## ----model, message = FALSE---------------------------------------------------
model = analyse_model(
  model = "adu_t",
  type = "adu",
  stage = c("load", "extract", "hydraulic"),
  verbose = FALSE,
  path = model_path
)


## ----limnigraph---------------------------------------------------------------
flood = generate_limnigraph(
  model = model,
  time = c(0, 5400, 10800),
  depth = cbind(facade_1 = c(0, 2, 0)),
  exposition = list(
    facade_1 = list(external = c("wall_A", "wall_B", "wall_C", "wall_D", "wall_E", "wall_F",
      "wall_G", "wall_H"))
  )
)


## ----analysehscenop, fig.width = 7, fig.height = 7----------------------------
hydraulics = analyse_hydraulic(
  model = model,
  limnigraph = flood,
  opening_scenario = "open",
  stage = c("hydraulic", "display")
)


## ----analysehscencl, fig.width = 7, fig.height = 7----------------------------
hydraulics = analyse_hydraulic(
  model = model,
  limnigraph = flood,
  opening_scenario = "close",
  stage = c("hydraulic", "display")
)


## ----analysehscenco, fig.width = 7, fig.height = 7----------------------------
hydraulics = analyse_hydraulic(
  model = model,
  limnigraph = flood,
  opening_scenario = "combine",
  stage = c("hydraulic", "display")
)


## ----analysehcd, fig.width = 7, fig.height = 7--------------------------------
hydraulics = analyse_hydraulic(
  model = model,
  limnigraph = flood,
  opening_scenario = "close",
  Cd = 0.0,
  stage = c("hydraulic", "display")
)


## ----analysehclear, fig.width = 7, fig.height = 7-----------------------------
hydraulics = analyse_hydraulic(
  model = model,
  limnigraph = flood,
  opening_scenario = "close",
  clearance = c(under = 0.01, side = 0.02),
  height_break = Inf,
  stage = c("hydraulic", "display")
)


## ----analysehopbreak, fig.width = 7, fig.height = 7---------------------------
hydraulics = analyse_hydraulic(
  model = model,
  limnigraph = flood,
  opening_scenario = "close",
  height_break = 0.7,
  stage = c("hydraulic", "display")
)


## ----analysehdt, fig.width = 7, fig.height = 7--------------------------------
hydraulics = analyse_hydraulic(
  model = model,
  limnigraph = flood,
  opening_scenario = "combine",
  dt_max = 0.1,
  stage = c("hydraulic", "display")
)


## ----hydraulicdanger----------------------------------------------------------
hydraulic = analyse_hydraulic(
  model = model,
  limnigraph = flood,
  opening_scenario = "close",
  stage = c("hydraulic", "dangerosity"),
  sim_id = "integrated_model"
)


## ----dang---------------------------------------------------------------------
head(hydraulic[["danger"]], 10) |> knitr::kable()

