## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----data, include = FALSE----------------------------------------------------
#> set up model to use example shipped with floodam
dataset = read.csv2(
  system.file(
    file.path(
      "extdata","component_elementary", "component_elementary.csv"
    ), 
    package = "floodam.building"
  )
)
selection = c("component_elementary_label_fr", "component_elementary", "v_min", "v_max", "v_support")
col_names = c( "nom de la composante", "ID fichier input", "Min. valeur", "Max. valeur", "magnitude/support")

## ----echo=FALSE, results="asis"-----------------------------------------------
# loop to generate as many level 2 (##) headers and tables as elements contained in vector section
# the use of htmltools::tagList() and htmltools::tags$h2() is needed to create the sections programmatically with DT

section = unique(na.omit(dataset[["category_dwelling_02"]]))
section = section[nchar(section)>0]

htmltools::tagList(
  lapply(
    section,
    function(x, cols, col_names){
      selection = dataset[["category_dwelling_02"]] == x
      selection[is.na(selection)] = FALSE
      list(
        htmltools::tags$h2(paste0(x,"s")), #level 2 (##) headers
        DT::datatable( #table
          dataset[
            dataset[["category_dwelling_01"]] == "building" & selection, cols
          ],
          rownames = FALSE,
          colnames = col_names,
          options = list(
            pageLength = 5, autoWidth = TRUE,
            lengthMenu = c(5, 10, 15, 20, 25, 50, 100)
          )
        )
      )
    },
    cols = selection,
    col_names = col_names
  )
)


## ----echo=FALSE, results="asis"-----------------------------------------------
# the use of htmltools::tagList() and htmltools::tags$h2() is needed to create the sections programmatically with DT

section = unique(dataset[["category_dwelling_02"]]) #there are NA
section = section[nchar(section)==0] #NA are kept

DT::datatable(
  dataset[
    dataset[["category_dwelling_01"]] == "building" &
    dataset[["category_dwelling_02"]] %in% section, selection
  ],
  rownames = FALSE,
  colnames = col_names,
  options = list(
    pageLength = 5, autoWidth = TRUE,
    lengthMenu = c(5, 10, 15, 20, 25, 50, 100)
  )
)


