#' @title floodam.building
#' @description Creation of flood damage functions for buildings
#' @author Frédéric Grelot <frederic.grelot@inrae.fr>
#' @name floodam.building
#' @useDynLib floodam.building, .registration=TRUE
#' @importFrom Rcpp sourceCpp
"_PACKAGE"

.onLoad = function(libname, pkgname) {
    options(floodam_building_check = TRUE)
    options(floodam_building_dilapidation = .5)
	options(floodam_building_d_select = c(12, 60, 120))
	options(floodam_building_hazard_range = 
		list(
			h = seq(0, 500, 10),
			d = seq(0, 144, 12)
		)
	)
	options(floodam_building_file_name = 
		list(
			building = "building.xml",
			component = "component.csv",
			furniture = "furniture.csv",
			category_model = "category_model.csv",
			check = "check.log",
			BUILDING = "BUILDING.txt"
		)
	)
	options(floodam_building_graph = TRUE)
	options(floodam_building_path = 
		list(
			data = "data-floodam",
			damaging = 
				system.file(
					"extdata/component_elementary",
					package = "floodam.building"
				),
			parameter =
				system.file(
					"extdata/parameter",
					package = "floodam.building"
				),
			adaptation = "data-floodam/adaptation",
			output =  "output-floodam",
			damaging_output =  "output-floodam/damaging",
			damaging_output_csv = "output-floodam/damaging/csv",
			damaging_output_pdf = "output-floodam/damaging/pdf"
		)
	)
	options(
        floodam_building_stage = c(
            "load",
            "extract",
            "damaging",
            "hydraulic",
            "graph",
            "save",
            "display"
        )
    )
	options(
		floodam_building_hydrau_stage = c(
			"hydraulic",
			"dangerosity",
			"damaging",
			"save",
			"graph",
			"display"
		)
	)
	options(floodam_building_talkative = FALSE)
	options(floodam_building_type_building = "xml")
	options(floodam_building_version_building = "version_02")
	options(floodam_building_id_letter = c(LETTERS, sprintf("%s%s", rep(LETTERS, each = 26), LETTERS)))
	options(floodam_building_verbose = TRUE)
	options(floodam_building_hydraulic_discharge_coefficient = 0.42)
	options(floodam_building_hydraulic_initial_water_depth_interior = 0)
	options(floodam_building_hydraulic_close_opening_clearance = c("under" = 0.5, "side" = .5))
	options(floodam_building_reconstruction_value_surface = 
		list(
			dwelling = 1650,
			activity = 1438
		)
	)

	invisible()
}
