#' Define some useful path to use floodam
#
#' @param model_name character, name given to the model
#' @param type character, type of model that is loaded
#' @param path list of useful paths, that will be updated. Default to getOption("floodam_building_path").
#' @return list of useful paths, adjusted with model_name and type.
#' Create paths for outputs also.
#'
#' @export

update_path = function(model_name = NULL, type = NULL, path = getOption("floodam_building_path"))
{
	
	if (!is.null(type)) {
		# selected data
		path[["model"]] = file.path(path[["data"]], "model", type)
		if (type == "activity") {
			path[["esane"]] = file.path("data", "INSEE", "esane")
			path[["sirene"]] = file.path(path[["data"]], "extrapolation", type, "sirene")
			path[["extrapolation"]] = file.path(path[["data"]], "extrapolation", type, "esane")
			path[["category"]] = file.path(path[["data"]], "extrapolation", type, "esane")
		}
		if (!file.exists(path[["model"]])) {
			msg = sprintf("No directory %s found. Nothing can be loaded. Please check type.", path[["model"]])
			stop(msg)
		}
		
		# output
		path[["model_output"]] = file.path(path[["output"]], "model", type)
		if (type == "activity") {
			path[["category_output"]] = file.path(path[["output"]], "category", type)
			path[["extrapolation_output"]] = file.path(path[["output"]], "extrapolation", type)
			path[["analysis"]] = file.path(path[["output"]], "analysis")
			path[["analysis_model"]] = file.path(path[["analysis"]], "model", type)
		}
	}

	if (!is.null(model_name)) {
		if (is.null(path[["model_output"]])) stop("No directory for model output yet defined. May need a type...")		
		path[["model_log"]] = file.path(path[["model_output"]], model_name)
		path[["model_output_building_plan"]] = file.path(path[["model_output"]], model_name)
		path[["model_output_damaging"]] = file.path(path[["model_output"]], model_name)
		path[["model_output_hydraulic"]] = file.path(path[["model_output"]], model_name)
	}
	
	# Create paths, if missing
  lapply(path, dir.create, showWarnings = FALSE, recursive = TRUE)

  return(path)
}
