#' Update mean data from INSEE data
#' 
#' @param path where to find the data
#' @return Nothing
#' 
#' @keywords internal

update_esane_mean = function(path) {
	path_input = file.path(path, "net")
	path_output = file.path(path, "mean")

	dir.create(path_output, FALSE, TRUE)
	
	for (level in c("N0", "N1", "N2", "N3", "N5")) {
		files = list.files(path = path_input, pattern = level)
		input = lapply(file.path(path_input, files), utils::read.csv2, row.names = "ACTIVITY")
		names(input) = sapply(strsplit(files, "-"), function(x){x[2]})
		ape = unique(unlist(lapply(input, row.names)))
		input = lapply(input, normalise, ape)
		input = list2array(input)
		
		utils::write.csv2(apply(input, c(1, 2), mean, na.rm = TRUE), file.path(path_output, sprintf("esane-mean-%s.csv", level)))
	}
}

list2array = function(x) {
	array(unlist(x), c(dim(x[[1]]), length(x)), c(dimnames(x[[1]]), list(names(x))))
}

normalise = function(x, rows) {
	x = as.matrix(x)
	result = matrix(NA, length(rows), ncol(x), dimnames = list(rows, colnames(x)))
	result[row.names(x),] = x
	result
}